/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.scroller;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.R;
import com.didi.hummer.component.refresh.HummerFooter;
import com.didi.hummer.component.refresh.HummerHeader;
import com.didi.hummer.component.scroller.OnScrollListener;
import com.didi.hummer.component.scroller.VScrollView;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.FixedNoneBox;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.base.Event;
import com.didi.hummer.render.event.view.ScrollEvent;
import com.didi.hummer.render.style.HummerLayout;
import com.didi.hummer.render.style.HummerLayoutExtendUtils;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.DPUtil;
import com.didi.hummer.render.utility.YogaNodeUtil;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaUnit;
import com.scwang.smart.refresh.layout.SmartRefreshLayout;
import com.scwang.smart.refresh.layout.api.RefreshFooter;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="Scroller")
public class Scroller
extends HMBase<SmartRefreshLayout>
implements HMBase.PositionChangedListener {
    private SmartRefreshLayout refreshLayout;
    private HummerHeader hummerHeader;
    private HummerFooter hummerFooter;
    private VScrollView scrollView;
    private HummerLayout layout;
    private JSCallback onScrollToTopListener;
    private JSCallback onScrollToBottomListener;
    private HummerContext hummerContext;
    private ScrollEvent scrollEvent = new ScrollEvent();
    private List<HMBase> children = new ArrayList<HMBase>();
    private Map<HMBase, FixedNoneBox> fixedNoneBoxMap = new HashMap<HMBase, FixedNoneBox>();
    @JsProperty(value="showScrollBar")
    private boolean showScrollBar;
    @JsProperty(value="refreshView")
    private HMBase refreshView;
    @JsProperty(value="loadMoreView")
    private HMBase loadMoreView;
    @JsProperty(value="onRefresh")
    private JSCallback refreshCallback;
    @JsProperty(value="onLoadMore")
    private JSCallback loadMoreCallback;
    @JsProperty(value="bounces")
    public boolean bounces;

    public Scroller(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
        this.hummerContext = context;
    }

    protected SmartRefreshLayout createViewInstance(Context context) {
        this.scrollView = (VScrollView)LayoutInflater.from((Context)context).inflate(R.layout.scroll_view, null, false);
        this.scrollView.setClipChildren(false);
        this.scrollView.setFillViewport(true);
        this.refreshLayout = new SmartRefreshLayout(context);
        this.refreshLayout.setEnableRefresh(false);
        this.refreshLayout.setEnableLoadMore(false);
        this.refreshLayout.setEnableOverScrollDrag(true);
        this.refreshLayout.setRefreshContent((View)this.scrollView);
        this.hummerHeader = new HummerHeader(context);
        this.hummerFooter = new HummerFooter(context);
        this.refreshLayout.setRefreshHeader((RefreshHeader)this.hummerHeader);
        this.refreshLayout.setRefreshFooter((RefreshFooter)this.hummerFooter);
        this.hummerHeader.setOnRefreshListener(new HummerHeader.OnRefreshListener(){

            @Override
            public void onRefreshStarted() {
                if (Scroller.this.refreshCallback != null) {
                    Scroller.this.refreshCallback.call(new Object[]{1});
                }
            }

            @Override
            public void onRefreshing() {
                if (Scroller.this.refreshCallback != null) {
                    Scroller.this.refreshCallback.call(new Object[]{2});
                }
            }

            @Override
            public void onRefreshFinished() {
                if (Scroller.this.refreshCallback != null) {
                    Scroller.this.refreshCallback.call(new Object[]{0});
                }
            }
        });
        this.hummerFooter.setOnLoadListener(new HummerFooter.OnLoadListener(){

            @Override
            public void onLoadStarted() {
            }

            @Override
            public void onLoading() {
                if (Scroller.this.loadMoreCallback != null) {
                    Scroller.this.loadMoreCallback.call(new Object[]{1});
                }
            }

            @Override
            public void onLoadFinished() {
            }
        });
        return this.refreshLayout;
    }

    public void onCreate() {
        super.onCreate();
        this.initScrollView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.scrollView.release();
    }

    protected void onStyleUpdated(Map<String, Object> newStyle) {
        this.layout.getYogaNode().copyStyle(this.getYogaNode());
        this.adjustWidthAndHeight();
        this.adjustMinMaxWidthAndHeight();
    }

    private void initScrollView() {
        this.layout = new HummerLayout(this.getContext());
        this.layout.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.adjustWidthAndHeight());
        this.scrollView.addView((View)this.layout);
        YogaNode scrollViewNode = YogaNodeUtil.createYogaNode();
        scrollViewNode.setData((Object)this.scrollView);
        scrollViewNode.addChildAt(this.layout.getYogaNode(), 0);
        scrollViewNode.setOverflow(YogaOverflow.SCROLL);
        this.getYogaNode().setMeasureFunction(null);
        this.getYogaNode().setFlexShrink(1.0f);
        this.getYogaNode().addChildAt(scrollViewNode, 0);
        this.scrollView.setVerticalScrollBarEnabled(false);
        this.scrollView.setOnScrollListener(new OnScrollListener(){

            @Override
            public void onScrollStarted() {
                if (!Scroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                Scroller.this.scrollEvent.setType("scroll");
                Scroller.this.scrollEvent.setState(1);
                Scroller.this.scrollEvent.setOffsetX(0.0f);
                Scroller.this.scrollEvent.setOffsetY(0.0f);
                Scroller.this.scrollEvent.setDx(0.0f);
                Scroller.this.scrollEvent.setDy(0.0f);
                Scroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                Scroller.this.mEventManager.dispatchEvent("scroll", (Event)Scroller.this.scrollEvent);
            }

            @Override
            public void onScrollFinished() {
                if (!Scroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                Scroller.this.scrollEvent.setType("scroll");
                Scroller.this.scrollEvent.setState(3);
                Scroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                Scroller.this.mEventManager.dispatchEvent("scroll", (Event)Scroller.this.scrollEvent);
            }

            @Override
            public void onScrollUp() {
                if (!Scroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                Scroller.this.scrollEvent.setType("scroll");
                Scroller.this.scrollEvent.setState(4);
                Scroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                Scroller.this.mEventManager.dispatchEvent("scroll", (Event)Scroller.this.scrollEvent);
            }

            @Override
            public void onScrollChanged(View scrollView, int x, int y, int dx, int dy) {
                if (!Scroller.this.mEventManager.contains("scroll")) {
                    return;
                }
                Scroller.this.scrollEvent.setType("scroll");
                Scroller.this.scrollEvent.setState(2);
                Scroller.this.scrollEvent.setOffsetX(DPUtil.px2dpF((Context)Scroller.this.getContext(), (float)x));
                Scroller.this.scrollEvent.setOffsetY(DPUtil.px2dpF((Context)Scroller.this.getContext(), (float)y));
                Scroller.this.scrollEvent.setDx(DPUtil.px2dpF((Context)Scroller.this.getContext(), (float)dx));
                Scroller.this.scrollEvent.setDy(DPUtil.px2dpF((Context)Scroller.this.getContext(), (float)dy));
                Scroller.this.scrollEvent.setTimestamp(System.currentTimeMillis());
                Scroller.this.mEventManager.dispatchEvent("scroll", (Event)Scroller.this.scrollEvent);
            }
        });
        this.scrollView.setOnScrollToTopListener(() -> {
            if (this.onScrollToTopListener != null) {
                this.onScrollToTopListener.call(new Object[0]);
            }
        });
        this.scrollView.setOnScrollToBottomListener(() -> {
            if (this.onScrollToBottomListener != null) {
                this.onScrollToBottomListener.call(new Object[0]);
            }
        });
    }

    private void adjustWidthAndHeight() {
        if (this.getYogaNode().getWidth().unit == YogaUnit.AUTO) {
            this.layout.getYogaNode().setWidthAuto();
        } else {
            this.layout.getYogaNode().setWidthPercent(100.0f);
        }
        if (this.getYogaNode().getHeight().unit == YogaUnit.AUTO) {
            this.layout.getYogaNode().setHeightAuto();
        } else {
            this.layout.getYogaNode().setHeightPercent(100.0f);
        }
    }

    private void adjustMinMaxWidthAndHeight() {
        this.layout.getYogaNode().setMinWidth(Float.NaN);
        this.layout.getYogaNode().setMaxWidth(Float.NaN);
        this.layout.getYogaNode().setMinHeight(Float.NaN);
        this.layout.getYogaNode().setMaxHeight(Float.NaN);
    }

    @JsMethod(value="appendChild")
    public void appendChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        this.children.add(child);
        HMBase finalChild = child;
        this.getNode().appendChild(child.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        this.layout.addView(finalChild);
    }

    @JsMethod(value="removeChild")
    public void removeChild(HMBase child) {
        if (child == null) {
            return;
        }
        child.getJSValue().unprotect();
        child.setPositionChangedListener(null);
        this.children.remove(child);
        this.getNode().removeChild(child.getNode());
        if (this.fixedNoneBoxMap.containsKey(child)) {
            FixedNoneBox noneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            this.layout.removeView((HMBase)noneBox);
            return;
        }
        this.layout.removeView(child);
    }

    @JsMethod(value="removeAll")
    public void removeAll() {
        for (Map.Entry<HMBase, FixedNoneBox> entry : this.fixedNoneBoxMap.entrySet()) {
            HMBase hmBase = entry.getKey();
            FixedNoneBox noneBox = entry.getValue();
            this.hummerContext.getContainer().removeView(hmBase);
            this.layout.removeView((HMBase)noneBox);
        }
        this.fixedNoneBoxMap.clear();
        for (HMBase hmBase : this.children) {
            hmBase.getJSValue().unprotect();
            hmBase.setPositionChangedListener(null);
        }
        this.children.clear();
        this.getNode().removeAll();
        this.layout.removeAllViews();
    }

    @JsMethod(value="insertBefore")
    public void insertBefore(HMBase child, HMBase existing) {
        if (child == null || existing == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        this.children.add(child);
        HMBase finalChild = child;
        HMBase finalExisting = existing;
        this.getNode().insertBefore(child.getNode(), existing.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(existing)) {
            finalExisting = (HMBase)this.fixedNoneBoxMap.get(existing);
        }
        this.layout.insertBefore(finalChild, finalExisting);
    }

    @JsMethod(value="replaceChild")
    public void replaceChild(HMBase child, HMBase old) {
        if (child == null || old == null) {
            return;
        }
        child.getJSValue().protect();
        child.setPositionChangedListener((HMBase.PositionChangedListener)this);
        old.getJSValue().unprotect();
        old.setPositionChangedListener(null);
        this.children.add(child);
        this.children.remove(old);
        HMBase finalChild = child;
        HMBase finalOld = old;
        this.getNode().replaceChild(child.getNode(), old.getNode());
        if (child.getPosition() == HummerLayoutExtendUtils.Position.FIXED) {
            this.hummerContext.getContainer().addView(child);
            FixedNoneBox fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            finalChild = fixedNoneBox;
        }
        if (this.fixedNoneBoxMap.containsKey(old)) {
            this.hummerContext.getContainer().removeView(old);
            finalOld = (HMBase)this.fixedNoneBoxMap.get(old);
        }
        this.layout.replaceView(finalChild, finalOld);
    }

    @Deprecated
    @JsMethod(value="getElementById")
    public HMBase getSubview(String viewID) {
        HMBase result = this.layout.getViewById(viewID);
        if (result == null) {
            for (Map.Entry<HMBase, FixedNoneBox> entry : this.fixedNoneBoxMap.entrySet()) {
                HMBase hmBase = entry.getKey();
                if (!hmBase.getViewID().equals(viewID)) continue;
                result = hmBase;
                break;
            }
        }
        if (result != null) {
            result.getJSValue().protect();
        }
        return result;
    }

    @Deprecated
    @JsMethod(value="layout")
    public void layout() {
        this.layout.requestLayout();
    }

    public void setShowScrollBar(boolean isShow) {
        this.scrollView.setVerticalScrollBarEnabled(isShow);
    }

    public void setRefreshView(HMBase view) {
        this.refreshLayout.setEnableRefresh(true);
        this.hummerHeader.addHeaderView(view);
    }

    public void setLoadMoreView(HMBase view) {
        this.refreshLayout.setEnableLoadMore(true);
        this.hummerFooter.addFooterView(view);
    }

    public void setOnRefresh(JSCallback callback) {
        this.refreshCallback = callback;
    }

    public void setOnLoadMore(JSCallback callback) {
        this.loadMoreCallback = callback;
    }

    @JsMethod(value="stopPullRefresh")
    public void stopPullRefresh() {
        this.refreshLayout.finishRefresh(30);
    }

    @JsMethod(value="stopLoadMore")
    public void stopLoadMore(boolean enable) {
        if (enable) {
            this.refreshLayout.finishLoadMore();
        } else {
            this.refreshLayout.finishLoadMoreWithNoMoreData();
        }
        if (this.loadMoreCallback != null) {
            this.loadMoreCallback.call(new Object[]{enable ? 0 : 2});
        }
    }

    public void setBounces(boolean bounces) {
        this.refreshLayout.setEnableOverScrollDrag(bounces);
    }

    @JsMethod(value="scrollTo")
    public void scrollTo(Object x, Object y) {
        int nX = (int)HummerStyleUtils.convertNumber((Object)x);
        int nY = (int)HummerStyleUtils.convertNumber((Object)y);
        this.scrollView.smoothScrollTo(nX, nY);
    }

    @JsMethod(value="scrollBy")
    public void scrollBy(Object dx, Object dy) {
        int nDx = (int)HummerStyleUtils.convertNumber((Object)dx);
        int nDy = (int)HummerStyleUtils.convertNumber((Object)dy);
        this.scrollView.smoothScrollBy(nDx, nDy);
    }

    @JsMethod(value="scrollToTop")
    public void scrollToTop() {
        this.scrollView.fullScroll(33);
    }

    @JsMethod(value="scrollToBottom")
    public void scrollToBottom() {
        this.scrollView.fullScroll(130);
    }

    @JsMethod(value="setOnScrollToTopListener")
    public void setOnScrollToTopListener(JSCallback callback) {
        this.onScrollToTopListener = callback;
    }

    @JsMethod(value="setOnScrollToBottomListener")
    public void setOnScrollToBottomListener(JSCallback callback) {
        this.onScrollToBottomListener = callback;
    }

    @Deprecated
    @JsMethod(value="updateContentSize")
    public void updateContentSize() {
    }

    public void dispatchChildPositionChanged(HMBase child, HummerLayoutExtendUtils.Position origin, HummerLayoutExtendUtils.Position replace) {
        FixedNoneBox fixedNoneBox;
        if (origin == HummerLayoutExtendUtils.Position.FIXED && replace == HummerLayoutExtendUtils.Position.YOGA && this.fixedNoneBoxMap.containsKey(child)) {
            fixedNoneBox = this.fixedNoneBoxMap.remove(child);
            this.hummerContext.getContainer().removeView(child);
            this.layout.replaceView(child, (HMBase)fixedNoneBox);
        }
        if (origin == HummerLayoutExtendUtils.Position.YOGA && replace == HummerLayoutExtendUtils.Position.FIXED) {
            fixedNoneBox = new FixedNoneBox(this.hummerContext);
            this.fixedNoneBoxMap.put(child, fixedNoneBox);
            this.layout.replaceView((HMBase)fixedNoneBox, child);
            this.hummerContext.getContainer().addView(child);
        }
    }

    public void resetStyle() {
        super.resetStyle();
        this.setShowScrollBar(false);
    }
}

