/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.scroller;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import com.didi.hummer.component.input.FocusUtil;
import com.didi.hummer.component.input.KeyboardUtil;
import com.didi.hummer.component.scroller.OnScrollListener;
import com.didi.hummer.component.scroller.OnScrollToBottomListener;
import com.didi.hummer.component.scroller.OnScrollToTopListener;
import com.didi.hummer.component.scroller.ScrollViewStateObserver;

public class VScrollView
extends ScrollView {
    private ScrollViewStateObserver observer;
    private boolean isScrollToEnd = false;
    private OnScrollListener onScrollListener = null;
    private OnScrollToTopListener onScrollToTopListener = null;
    private OnScrollToBottomListener onScrollToBottomListener = null;

    public VScrollView(Context context) {
        this(context, null);
    }

    public VScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.setOverScrollMode(2);
        this.setImportantForAccessibility(2);
        this.observer = new ScrollViewStateObserver();
        this.observer.setOnScrollStateListener(state -> {
            switch (state) {
                case 1: {
                    if (this.onScrollListener == null) break;
                    this.onScrollListener.onScrollStarted();
                    break;
                }
                case 3: {
                    if (this.onScrollListener == null) break;
                    this.onScrollListener.onScrollUp();
                    break;
                }
                case 4: {
                    if (this.onScrollListener == null) break;
                    this.onScrollListener.onScrollFinished();
                    break;
                }
            }
        });
    }

    public void release() {
        if (this.observer != null) {
            this.observer.release();
        }
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.onScrollListener = listener;
    }

    public void setOnScrollToTopListener(OnScrollToTopListener listener) {
        this.onScrollToTopListener = listener;
    }

    public void setOnScrollToBottomListener(OnScrollToBottomListener listener) {
        this.onScrollToBottomListener = listener;
    }

    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        super.onScrollChanged(x, y, oldx, oldy);
        this.observer.onScrollChanged(y, oldy);
        if (this.onScrollListener != null) {
            this.onScrollListener.onScrollChanged((View)this, x, y, x - oldx, y - oldy);
        }
        this.hideKeyboardIfNeed(Math.abs(y - oldy));
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
        if (clampedY) {
            if (!this.isScrollToEnd) {
                this.isScrollToEnd = true;
                if (scrollY > 0) {
                    if (this.onScrollToBottomListener != null) {
                        this.onScrollToBottomListener.onScrollToBottom();
                    }
                } else if (this.onScrollToTopListener != null) {
                    this.onScrollToTopListener.onScrollToTop();
                }
            }
        } else {
            this.isScrollToEnd = false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.isScrollToEnd = false;
        }
        this.observer.onInterceptTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            FocusUtil.clearFocus(this.getContext());
        }
        this.observer.onTouchEvent(ev);
        return super.onTouchEvent(ev);
    }

    private void hideKeyboardIfNeed(int d) {
        Activity act;
        if (d > 20 && this.getContext() instanceof Activity && (act = (Activity)this.getContext()).getCurrentFocus() != null && act.getCurrentFocus().getWindowToken() != null && (act.getWindow().getAttributes().softInputMode & 0x10) == 0) {
            KeyboardUtil.hideKeyboard(act.getCurrentFocus());
        }
    }
}

