/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.switchview;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.widget.CompoundButton;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.event.base.Event;
import com.didi.hummer.render.event.view.SwitchEvent;

@Component(value="Switch")
public class Switch
extends HMBase<android.widget.Switch>
implements CompoundButton.OnCheckedChangeListener {
    @Nullable
    private Integer mOnTrackColor;
    @Nullable
    private Integer mOffTrackColor;
    @JsProperty(value="checked")
    private boolean checked;

    public Switch(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
    }

    public void onCreate() {
        super.onCreate();
        ((android.widget.Switch)this.getView()).setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
    }

    public void onDestroy() {
        super.onDestroy();
        ((android.widget.Switch)this.getView()).setOnCheckedChangeListener(null);
    }

    protected android.widget.Switch createViewInstance(Context context) {
        return new android.widget.Switch(context);
    }

    public void setChecked(boolean checked) {
        this.doChecked(checked);
        this.getNode().setContent(checked ? "Yes" : "No");
    }

    @JsAttribute(value={"onColor"})
    public void setOnColor(int color) {
        this.mOnTrackColor = color;
        if (((android.widget.Switch)this.getView()).isChecked()) {
            this.setTrackColor(color);
        }
    }

    @JsAttribute(value={"offColor"})
    public void setOffColor(int color) {
        this.mOffTrackColor = color;
        if (!((android.widget.Switch)this.getView()).isChecked()) {
            this.setTrackColor(color);
        }
    }

    @JsAttribute(value={"thumbColor"})
    public void setThumbColor(int color) {
        this.setColor(((android.widget.Switch)this.getView()).getThumbDrawable(), color);
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.checked = isChecked;
        this.setTrackColor(isChecked);
        SwitchEvent switchEvent = new SwitchEvent();
        switchEvent.setType("switch");
        switchEvent.setTimestamp(System.currentTimeMillis());
        switchEvent.setState(isChecked);
        this.mEventManager.dispatchEvent("switch", (Event)switchEvent);
    }

    public void doChecked(boolean checked) {
        if (((android.widget.Switch)this.getView()).isChecked() != checked) {
            ((android.widget.Switch)this.getView()).setChecked(checked);
            this.setTrackColor(checked);
        }
    }

    private void setColor(Drawable drawable2, @Nullable Integer color) {
        if (color == null) {
            drawable2.clearColorFilter();
        } else {
            drawable2.setColorFilter(color.intValue(), PorterDuff.Mode.MULTIPLY);
        }
    }

    private void setTrackColor(boolean checked) {
        this.setTrackColor(checked ? this.mOnTrackColor : this.mOffTrackColor);
    }

    private void setTrackColor(@Nullable Integer color) {
        this.setColor(((android.widget.Switch)this.getView()).getTrackDrawable(), color);
    }

    public void resetStyle() {
        super.resetStyle();
        this.mOnTrackColor = null;
        this.mOffTrackColor = null;
        ((android.widget.Switch)this.getView()).getTrackDrawable().clearColorFilter();
        ((android.widget.Switch)this.getView()).getThumbDrawable().clearColorFilter();
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "onColor": {
                this.setOnColor((Integer)value);
                break;
            }
            case "offColor": {
                this.setOffColor((Integer)value);
                break;
            }
            case "thumbColor": {
                this.setThumbColor((Integer)value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

