/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.SparseArray;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.adapter.font.IFontAdapter;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.util.HMLog;
import java.util.HashMap;
import java.util.Map;

public class FontManager {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    public static final String DEFAULT_FONT_FAMILY = "DEFAULT_FONT_FAMILY";
    private static FontManager instance;
    private Map<String, FontFamily> mFontCache = new HashMap<String, FontFamily>();

    private FontManager() {
    }

    public static FontManager getInstance() {
        if (instance == null) {
            instance = new FontManager();
        }
        return instance;
    }

    public Typeface getTypeface(HummerContext context, String fontFamilyName, int style2) {
        IFontAdapter fontAdapter;
        Typeface typeface;
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = (fontAdapter = HummerSDK.getHummerConfig((String)context.getNamespace()).getFontAdapter()).loadFont(context.getApplicationContext(), DEFAULT_FONT_FAMILY.equals(fontFamilyName) ? null : fontFamilyName, style2)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    @Deprecated
    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, FONTS_ASSET_PATH, style2, assetManager);
    }

    @Deprecated
    public Typeface getTypeface(String fontFamilyName, String fontsAssetsPath, int style2, AssetManager assetManager) {
        Typeface typeface;
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = FontManager.createTypeface(fontFamilyName, fontsAssetsPath, style2, assetManager)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    public void setTypeface(String fontFamilyName, int style2, Typeface typeface) {
        if (typeface != null) {
            FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
            if (fontFamily == null) {
                fontFamily = new FontFamily();
                this.mFontCache.put(fontFamilyName, fontFamily);
            }
            fontFamily.setTypeface(style2, typeface);
        }
    }

    private static Typeface createTypeface(String fontFamilyName, String fontsAssetsPath, int style2, AssetManager assetManager) {
        if (fontsAssetsPath == null) {
            fontsAssetsPath = FONTS_ASSET_PATH;
        } else if (!TextUtils.isEmpty((CharSequence)fontsAssetsPath) && !fontsAssetsPath.endsWith("/")) {
            fontsAssetsPath = fontsAssetsPath + "/";
        }
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = fontsAssetsPath + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (Exception e) {
                HMLog.w((String)"HummerNative", (String)e.getMessage());
            }
        }
        return null;
    }

    private static class FontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private FontFamily() {
        }

        public Typeface getTypeface(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypeface(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }
}

