/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.style.ImageSpan;
import java.lang.ref.WeakReference;

public class ImageSpanEx
extends ImageSpan {
    public static final int ALIGN_TOP = 2;
    public static final int ALIGN_CENTER = 3;
    private WeakReference<Drawable> mDrawableRef;

    public ImageSpanEx(@NonNull Drawable d) {
        super(d, 1);
    }

    public ImageSpanEx(@NonNull Drawable d, int verticalAlignment) {
        super(d, verticalAlignment);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (this.mVerticalAlignment == 1 || this.mVerticalAlignment == 0) {
            return super.getSize(paint, text, start, end, fm);
        }
        Drawable d = this.getCachedDrawable();
        Rect rect = d.getBounds();
        if (fm != null) {
            Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
            int fontHeight = fmPaint.bottom - fmPaint.top;
            int drHeight = rect.height();
            if (this.mVerticalAlignment == 2) {
                fm.ascent = fm.top = -drHeight;
                fm.bottom = fm.descent = fontHeight - drHeight;
            } else {
                int top = drHeight / 2 - fontHeight / 2;
                int bottom = drHeight / 2 + fontHeight / 2;
                fm.top = -bottom;
                fm.ascent = -bottom;
                fm.descent = top;
                fm.bottom = top;
            }
        }
        return rect.right;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mVerticalAlignment == 1 || this.mVerticalAlignment == 0) {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
            return;
        }
        Drawable b = this.getCachedDrawable();
        canvas.save();
        int transY = 0;
        if (this.mVerticalAlignment == 2) {
            transY = top;
        } else if (this.mVerticalAlignment == 3) {
            transY = (bottom - top - b.getBounds().height()) / 2 + top;
        }
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d = null;
        if (wr != null) {
            d = (Drawable)wr.get();
        }
        if (d == null) {
            d = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(d);
        }
        return d;
    }
}

