/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.text;

import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.widget.TextView;
import com.didi.hummer.component.text.FontManager;
import com.didi.hummer.component.text.ImageSpanEx;
import com.didi.hummer.component.text.OnRichTextGenerateListener;
import com.didi.hummer.component.text.TypefaceSpanEx;
import com.didi.hummer.component.text.URLSpanEx;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.didi.hummer.render.utility.YogaAttrUtils;
import com.didi.hummer.render.utility.YogaDrawableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RichTextHelper {
    private static final String RT_TEXT = "text";
    private static final String RT_COLOR = "color";
    private static final String RT_BACKGROUND_COLOR = "backgroundColor";
    private static final String RT_FONT_FAMILY = "fontFamily";
    private static final String RT_FONT_SIZE = "fontSize";
    private static final String RT_FONT_WEIGHT = "fontWeight";
    private static final String RT_FONT_STYLE = "fontStyle";
    private static final String RT_TEXT_DECORATION = "textDecoration";
    private static final String RT_IMAGE = "image";
    private static final String RT_IMAGE_WIDTH = "imageWidth";
    private static final String RT_IMAGE_HEIGHT = "imageHeight";
    private static final String RT_IMAGE_ALIGN = "imageAlign";
    private static final String RT_HREF = "href";
    private static final String RT_HREF_COLOR = "hrefColor";
    private static final String IMAGE_ALIGN_BASELINE = "baseline";
    private static final String IMAGE_ALIGN_TOP = "top";
    private static final String IMAGE_ALIGN_CENTER = "center";
    private static final String IMAGE_ALIGN_BOTTOM = "bottom";

    public static void generateRichText(HMBase hmBase, Object richText, OnRichTextGenerateListener listener) {
        if (richText instanceof Map) {
            RichTextHelper.generateRichText(hmBase, RichTextHelper.parseObjectRichText((Map)richText), listener);
        } else if (richText instanceof List) {
            RichTextHelper.generateRichText(hmBase, RichTextHelper.parseArrayRichText((List)richText), listener);
        }
    }

    private static RichText parseObjectRichText(Map richText) {
        Object objText = richText.get(RT_TEXT);
        Object objColor = richText.get(RT_COLOR);
        Object objBackgroundColor = richText.get(RT_BACKGROUND_COLOR);
        Object objFontFamily = richText.get(RT_FONT_FAMILY);
        Object objFontSize = richText.get(RT_FONT_SIZE);
        Object objFontWeight = richText.get(RT_FONT_WEIGHT);
        Object objFontStyle = richText.get(RT_FONT_STYLE);
        Object objTextDecoration = richText.get(RT_TEXT_DECORATION);
        Object objImage = richText.get(RT_IMAGE);
        Object objImageWidth = richText.get(RT_IMAGE_WIDTH);
        Object objImageHeight = richText.get(RT_IMAGE_HEIGHT);
        Object objImageAlign = richText.get(RT_IMAGE_ALIGN);
        Object objHref = richText.get(RT_HREF);
        Object objHrefColor = richText.get(RT_HREF_COLOR);
        RichText rt = new RichText();
        if (objText instanceof String) {
            rt.text = (String)objText;
        }
        if (objColor instanceof String) {
            rt.color = YogaAttrUtils.parseColor((String)((String)objColor));
        }
        if (objBackgroundColor instanceof String) {
            rt.backgroundColor = YogaAttrUtils.parseColor((String)((String)objBackgroundColor));
        }
        if (objFontFamily instanceof String) {
            rt.fontFamily = (String)objFontFamily;
        }
        if (objFontWeight instanceof String) {
            rt.fontWeight = (String)objFontWeight;
        }
        if (objFontStyle instanceof String) {
            rt.fontStyle = (String)objFontStyle;
        }
        if (objTextDecoration instanceof String) {
            rt.textDecoration = (String)objTextDecoration;
        }
        rt.fontSize = (int)HummerStyleUtils.convertNumber(objFontSize);
        if (objImage instanceof String) {
            rt.image = (String)objImage;
        }
        rt.imageWidth = (int)HummerStyleUtils.convertNumber(objImageWidth);
        rt.imageHeight = (int)HummerStyleUtils.convertNumber(objImageHeight);
        if (objImageAlign instanceof String) {
            rt.imageAlign = (String)objImageAlign;
        }
        if (objHref instanceof String) {
            rt.href = (String)objHref;
        }
        if (objHrefColor instanceof String) {
            rt.hrefColor = YogaAttrUtils.parseColor((String)((String)objHrefColor));
        }
        return rt;
    }

    private static List<RichText> parseArrayRichText(List richText) {
        ArrayList<RichText> rtList = new ArrayList<RichText>();
        for (Object obj : richText) {
            if (obj instanceof String) {
                rtList.add(new RichText((String)obj));
                continue;
            }
            if (!(obj instanceof Map)) continue;
            rtList.add(RichTextHelper.parseObjectRichText((Map)obj));
        }
        return rtList;
    }

    private static void generateRichText(HMBase hmBase, RichText richText, OnRichTextGenerateListener listener) {
        if (richText == null) {
            if (listener != null) {
                listener.onGenerated("");
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)richText.image) && TextUtils.isEmpty((CharSequence)richText.text)) {
            richText.text = " ";
        }
        SpannableString spanText = new SpannableString((CharSequence)richText.text);
        RichTextHelper.processHrefSpannableString(hmBase, spanText, richText, 0, spanText.length());
        if (!TextUtils.isEmpty((CharSequence)richText.image)) {
            RichTextHelper.processImageSpannableString(hmBase, spanText, richText, 0, spanText.length(), listener);
            return;
        }
        RichTextHelper.processTextStyleSpannableString(hmBase, spanText, richText, 0, spanText.length());
        if (listener != null) {
            listener.onGenerated((CharSequence)spanText);
        }
    }

    private static void generateRichText(HMBase hmBase, List<RichText> richTextList, OnRichTextGenerateListener listener) {
        if (richTextList == null || richTextList.isEmpty()) {
            if (listener != null) {
                listener.onGenerated("");
            }
            return;
        }
        StringBuilder wholeText = new StringBuilder();
        for (RichText richText : richTextList) {
            if (!TextUtils.isEmpty((CharSequence)richText.image) && TextUtils.isEmpty((CharSequence)richText.text)) {
                richText.text = " ";
            }
            wholeText.append(richText.text);
        }
        int index = 0;
        SpannableString spanText = new SpannableString((CharSequence)wholeText);
        for (RichText rt : richTextList) {
            int textLength = rt.text.length();
            RichTextHelper.processHrefSpannableString(hmBase, spanText, rt, index, index + textLength);
            if (!TextUtils.isEmpty((CharSequence)rt.image)) {
                RichTextHelper.processImageSpannableString(hmBase, spanText, rt, index, index + textLength, listener);
                index += textLength;
                continue;
            }
            RichTextHelper.processTextStyleSpannableString(hmBase, spanText, rt, index, index + textLength);
            index += textLength;
        }
        if (listener != null) {
            listener.onGenerated((CharSequence)spanText);
        }
    }

    private static void processTextStyleSpannableString(HMBase hmBase, SpannableString spanText, RichText richText, int start, int end) {
        if (richText.color != 0) {
            spanText.setSpan((Object)new ForegroundColorSpan(richText.color), start, end, 17);
        }
        if (richText.backgroundColor != 0) {
            spanText.setSpan((Object)new BackgroundColorSpan(richText.backgroundColor), start, end, 17);
        }
        if (!TextUtils.isEmpty((CharSequence)richText.fontFamily)) {
            int style2 = 0;
            if (hmBase.getView() instanceof TextView && ((TextView)hmBase.getView()).getTypeface() != null) {
                style2 = ((TextView)hmBase.getView()).getTypeface().getStyle();
            }
            Typeface typeface = FontManager.getInstance().getTypeface((HummerContext)hmBase.getContext(), richText.fontFamily, style2);
            spanText.setSpan((Object)new TypefaceSpanEx(typeface), start, end, 17);
        }
        if (richText.fontSize > 0) {
            spanText.setSpan((Object)new AbsoluteSizeSpan(richText.fontSize, false), start, end, 17);
        }
        boolean isBold = false;
        boolean isItalic = false;
        if (!TextUtils.isEmpty((CharSequence)richText.fontWeight) && richText.fontWeight.toLowerCase().equals("bold")) {
            isBold = true;
        }
        if (!TextUtils.isEmpty((CharSequence)richText.fontStyle) && richText.fontStyle.toLowerCase().equals("italic")) {
            isItalic = true;
        }
        if (isBold && isItalic) {
            spanText.setSpan((Object)new StyleSpan(3), start, end, 17);
        } else if (isBold) {
            spanText.setSpan((Object)new StyleSpan(1), start, end, 17);
        } else if (isItalic) {
            spanText.setSpan((Object)new StyleSpan(2), start, end, 17);
        }
        if (!TextUtils.isEmpty((CharSequence)richText.textDecoration)) {
            if (richText.textDecoration.equals("underline")) {
                spanText.setSpan((Object)new UnderlineSpan(), start, end, 17);
            } else if (richText.textDecoration.equals("line-through")) {
                spanText.setSpan((Object)new StrikethroughSpan(), start, end, 17);
            }
        }
    }

    private static void processImageSpannableString(HMBase hmBase, SpannableString spanText, RichText richText, int start, int end, OnRichTextGenerateListener listener) {
        if (!TextUtils.isEmpty((CharSequence)richText.image)) {
            YogaDrawableUtil.loadDrawable((HummerContext)((HummerContext)hmBase.getContext()), (String)richText.image, drawable2 -> {
                RichTextHelper.processDrawableSpannableString(spanText, richText, drawable2, start, end);
                if (listener != null) {
                    listener.onGenerated((CharSequence)spanText);
                }
            });
        }
    }

    private static void processDrawableSpannableString(SpannableString spanText, RichText richText, Drawable drawable2, int start, int end) {
        if (drawable2 == null) {
            return;
        }
        int imageWidth = drawable2.getIntrinsicWidth();
        int imageHeight = drawable2.getIntrinsicHeight();
        if (richText.imageWidth > 0) {
            imageWidth = richText.imageWidth;
        }
        if (richText.imageHeight > 0) {
            imageHeight = richText.imageHeight;
        }
        drawable2.setBounds(0, 0, imageWidth, imageHeight);
        spanText.setSpan((Object)new ImageSpanEx(drawable2, RichTextHelper.getImageAlign(richText.imageAlign)), start, end, 17);
    }

    private static void processHrefSpannableString(HMBase hmBase, SpannableString spanText, RichText richText, int start, int end) {
        if (!TextUtils.isEmpty((CharSequence)richText.href)) {
            spanText.setSpan((Object)new URLSpanEx(richText.href, richText.hrefColor), start, end, 17);
            if (hmBase.getView() instanceof TextView) {
                ((TextView)hmBase.getView()).setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
    }

    private static int getImageAlign(String imageAlign) {
        if (TextUtils.isEmpty((CharSequence)imageAlign)) {
            return 1;
        }
        switch (imageAlign) {
            default: {
                return 1;
            }
            case "top": {
                return 2;
            }
            case "center": {
                return 3;
            }
            case "bottom": 
        }
        return 0;
    }

    public static class RichText {
        public String text = "";
        public int color = 0;
        public int backgroundColor = 0;
        public String fontFamily;
        public int fontSize;
        public String fontWeight;
        public String fontStyle;
        public String textDecoration;
        public String image;
        public int imageWidth;
        public int imageHeight;
        public String imageAlign;
        public String href;
        public int hrefColor = 0;

        public RichText() {
        }

        public RichText(String text) {
            this.text = text;
        }
    }
}

