/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.text;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.widget.TextView;
import android.widget.Toast;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.text.FontManager;
import com.didi.hummer.component.text.RichTextHelper;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.HMGsonUtil;
import com.didi.hummer.render.component.view.HMBase;

@Component(value="Text")
public class Text
extends HMBase<TextView> {
    private ColorStateList orgTextColors;
    private float orgTextSize;
    private Typeface orgTypeface;
    private String fontWeight;
    private String fontStyle;
    private int xGravity = 0;
    private int yGravity = 0;
    @JsProperty(value="text")
    private String text;
    @JsProperty(value="richText")
    private Object richText;
    @Deprecated
    @JsProperty(value="formattedText")
    private String formattedText;
    @JsProperty(value="textCopyEnable")
    private boolean textCopyEnable;

    public Text(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
    }

    protected TextView createViewInstance(Context context) {
        return new TextView(context);
    }

    public void onCreate() {
        super.onCreate();
        this.orgTextColors = ((TextView)this.getView()).getTextColors();
        this.orgTextSize = ((TextView)this.getView()).getTextSize();
        this.setFontFamily("DEFAULT_FONT_FAMILY");
        this.orgTypeface = ((TextView)this.getView()).getTypeface();
        ((TextView)this.getView()).setGravity(8388627);
        ((TextView)this.getView()).setEllipsize(TextUtils.TruncateAt.END);
    }

    private void requestLayout() {
        this.getYogaNode().dirty();
        ((TextView)this.getView()).requestLayout();
    }

    private void setRowText(CharSequence text) {
        ((TextView)this.getView()).setText(text);
        this.requestLayout();
    }

    private Spanned fromHtml(String html) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)html, (int)0);
        }
        return Html.fromHtml((String)html);
    }

    public void setText(String text) {
        this.setRowText(text);
        this.getNode().setContent(text);
    }

    public void setRichText(Object richText) {
        if (richText instanceof String) {
            this.setText((String)richText);
            return;
        }
        RichTextHelper.generateRichText((HMBase)this, richText, this::setRowText);
        this.getNode().setContent(HMGsonUtil.toJson((Object)richText));
    }

    public void setFormattedText(String formattedText) {
        this.setRowText((CharSequence)this.fromHtml(formattedText));
        this.getNode().setContent(formattedText);
    }

    public void setTextCopyEnable(boolean textCopyEnable) {
        if (textCopyEnable) {
            ((TextView)this.getView()).setOnLongClickListener(v -> {
                ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
                ClipData clipData = ClipData.newPlainText((CharSequence)"copyText", (CharSequence)((TextView)this.getView()).getText());
                clipboardManager.setPrimaryClip(clipData);
                Toast toast = Toast.makeText((Context)this.getContext(), null, (int)0);
                toast.setText((CharSequence)"\u590d\u5236\u6210\u529f");
                toast.setGravity(17, 0, 0);
                toast.show();
                return false;
            });
        }
    }

    @JsAttribute(value={"color"})
    public void setColor(int color) {
        ((TextView)this.getView()).setTextColor(color);
    }

    @JsAttribute(value={"fontFamily"})
    public void setFontFamily(String fontFamily) {
        if (TextUtils.isEmpty((CharSequence)fontFamily)) {
            return;
        }
        String[] fontArray = fontFamily.split(",");
        if (fontArray.length == 0) {
            return;
        }
        int style2 = 0;
        if (((TextView)this.getView()).getTypeface() != null) {
            style2 = ((TextView)this.getView()).getTypeface().getStyle();
        }
        for (String font : fontArray) {
            Typeface typeface = FontManager.getInstance().getTypeface((HummerContext)this.getContext(), font.trim(), style2);
            if (typeface == null) continue;
            ((TextView)this.getView()).setTypeface(typeface);
            this.requestLayout();
            break;
        }
    }

    @JsAttribute(value={"fontSize"})
    public void setFontSize(float fontSize) {
        ((TextView)this.getView()).setTextSize(0, fontSize);
        this.requestLayout();
    }

    @JsAttribute(value={"fontWeight"})
    public void setFontWeight(String fontWeight) {
        if (TextUtils.isEmpty((CharSequence)fontWeight)) {
            return;
        }
        this.fontWeight = fontWeight.toLowerCase();
        this.processTextTypeface(this.fontWeight, this.fontStyle);
        this.requestLayout();
    }

    @JsAttribute(value={"fontStyle"})
    public void setFontStyle(String fontStyle) {
        if (TextUtils.isEmpty((CharSequence)fontStyle)) {
            return;
        }
        this.fontStyle = fontStyle.toLowerCase();
        this.processTextTypeface(this.fontWeight, this.fontStyle);
        this.requestLayout();
    }

    private void processTextTypeface(String fontWeight, String fontStyle) {
        if ("bold".equals(fontWeight) && "italic".equals(fontStyle)) {
            ((TextView)this.getView()).setTypeface(((TextView)this.getView()).getTypeface(), 3);
        } else if ("bold".equals(fontWeight)) {
            ((TextView)this.getView()).setTypeface(((TextView)this.getView()).getTypeface(), 1);
        } else if ("italic".equals(fontStyle)) {
            ((TextView)this.getView()).setTypeface(((TextView)this.getView()).getTypeface(), 2);
        } else {
            ((TextView)this.getView()).setTypeface(null, 0);
        }
    }

    @JsAttribute(value={"textAlign"})
    public void setTextAlign(String textAlign) {
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return;
        }
        switch (textAlign.toLowerCase()) {
            case "center": {
                ((TextView)this.getView()).setGravity(17);
                this.xGravity = 17;
                break;
            }
            default: {
                ((TextView)this.getView()).setGravity(8388627);
                this.xGravity = 8388627;
                break;
            }
            case "right": {
                ((TextView)this.getView()).setGravity(8388629);
                this.xGravity = 8388629;
            }
        }
        if (this.yGravity != 0) {
            ((TextView)this.getView()).setGravity(this.xGravity | this.yGravity);
        }
    }

    @JsAttribute(value={"textVerticalAlign"})
    public void setTextVerticalAlign(String textVerticalAlign) {
        if (TextUtils.isEmpty((CharSequence)textVerticalAlign)) {
            return;
        }
        switch (textVerticalAlign.toLowerCase()) {
            default: {
                ((TextView)this.getView()).setGravity(16);
                this.yGravity = 16;
                break;
            }
            case "top": {
                ((TextView)this.getView()).setGravity(48);
                this.yGravity = 48;
                break;
            }
            case "bottom": {
                ((TextView)this.getView()).setGravity(80);
                this.yGravity = 80;
            }
        }
        if (this.xGravity != 0) {
            ((TextView)this.getView()).setGravity(this.xGravity | this.yGravity);
        }
    }

    @JsAttribute(value={"textDecoration"})
    public void setTextDecoration(String textDecoration) {
        if (TextUtils.isEmpty((CharSequence)textDecoration)) {
            return;
        }
        switch (textDecoration.toLowerCase()) {
            case "underline": {
                ((TextView)this.getView()).getPaint().setFlags(8);
                break;
            }
            case "line-through": {
                ((TextView)this.getView()).getPaint().setFlags(16);
                break;
            }
            default: {
                ((TextView)this.getView()).getPaint().setFlags(0);
            }
        }
    }

    @JsAttribute(value={"textOverflow"})
    public void setTextOverflow(String overflow) {
        if (TextUtils.isEmpty((CharSequence)overflow)) {
            return;
        }
        switch (overflow.toLowerCase()) {
            case "clip": {
                ((TextView)this.getView()).setEllipsize(null);
                break;
            }
            default: {
                ((TextView)this.getView()).setEllipsize(TextUtils.TruncateAt.END);
            }
        }
    }

    @JsAttribute(value={"textLineClamp"})
    public void setTextLineClamp(int lines) {
        ((TextView)this.getView()).setSingleLine(lines == 1);
        ((TextView)this.getView()).setMaxLines(lines > 0 ? lines : Integer.MAX_VALUE);
        this.requestLayout();
    }

    @JsAttribute(value={"letterSpacing"})
    public void setLetterSpacing(float letterSpacing) {
        if (Build.VERSION.SDK_INT >= 21) {
            ((TextView)this.getView()).setLetterSpacing(letterSpacing);
            this.requestLayout();
        }
    }

    @JsAttribute(value={"lineSpacingMulti"})
    public void setLineSpacingMulti(float lineSpacingMulti) {
        ((TextView)this.getView()).setLineSpacing(0.0f, lineSpacingMulti);
        this.requestLayout();
    }

    public void resetStyle() {
        super.resetStyle();
        ((TextView)this.getView()).setTextColor(this.orgTextColors);
        ((TextView)this.getView()).setTextSize(0, this.orgTextSize);
        ((TextView)this.getView()).setTypeface(this.orgTypeface);
        this.setTextAlign("left");
        this.setTextDecoration("none");
        this.setTextOverflow("ellipsis");
        this.setTextLineClamp(Integer.MAX_VALUE);
        this.setLetterSpacing(0.0f);
        this.setLetterSpacing(1.0f);
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "color": {
                this.setColor((Integer)value);
                break;
            }
            case "fontFamily": {
                this.setFontFamily(String.valueOf(value));
                break;
            }
            case "fontSize": {
                this.setFontSize(((Float)value).floatValue());
                break;
            }
            case "fontWeight": {
                this.setFontWeight(String.valueOf(value));
                break;
            }
            case "fontStyle": {
                this.setFontStyle(String.valueOf(value));
                break;
            }
            case "textAlign": {
                this.setTextAlign(String.valueOf(value));
                break;
            }
            case "textDecoration": {
                this.setTextDecoration(String.valueOf(value));
                break;
            }
            case "textOverflow": {
                this.setTextOverflow(String.valueOf(value));
                break;
            }
            case "textLineClamp": {
                this.setTextLineClamp((int)((Float)value).floatValue());
                break;
            }
            case "letterSpacing": {
                this.setLetterSpacing(((Float)value).floatValue());
                break;
            }
            case "lineSpacingMulti": {
                this.setLineSpacingMulti(((Float)value).floatValue());
                break;
            }
            case "textVerticalAlign": {
                this.setTextVerticalAlign(String.valueOf(value));
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

