/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.text;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class TypefaceSpanEx
extends MetricAffectingSpan {
    private final Typeface typeface;

    public TypefaceSpanEx(Typeface type) {
        this.typeface = type;
    }

    public void updateDrawState(TextPaint ds) {
        TypefaceSpanEx.applyCustomTypeFace((Paint)ds, this.typeface);
    }

    public void updateMeasureState(TextPaint paint) {
        TypefaceSpanEx.applyCustomTypeFace((Paint)paint, this.typeface);
    }

    private static void applyCustomTypeFace(Paint paint, Typeface tf) {
        if (tf == null) {
            return;
        }
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int fake = oldStyle & ~tf.getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }
}

