/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.toast;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.render.component.view.HMBase;
import java.lang.reflect.Field;

@Component(value="Toast")
public class Toast {
    @JsMethod(value="show")
    public static void show(String msg, int duration) {
        android.widget.Toast toast = android.widget.Toast.makeText((Context)HummerSDK.appContext, (CharSequence)msg, (int)(duration <= 2000 ? 0 : 1));
        Toast.hook(toast);
        toast.show();
    }

    @JsMethod(value="custom")
    public static void custom(HMBase baseView, int duration) {
        android.widget.Toast toast = new android.widget.Toast(HummerSDK.appContext);
        Toast.hook(toast);
        toast.setDuration(duration <= 2000 ? 0 : 1);
        toast.setView(baseView.getView());
        toast.show();
    }

    private static void hook(android.widget.Toast toast) {
        if (Build.VERSION.SDK_INT != 25) {
            return;
        }
        try {
            Field sField_TN = android.widget.Toast.class.getDeclaredField("mTN");
            sField_TN.setAccessible(true);
            Field sField_TN_Handler = sField_TN.getType().getDeclaredField("mHandler");
            sField_TN_Handler.setAccessible(true);
            Object tn = sField_TN.get(toast);
            Handler preHandler = (Handler)sField_TN_Handler.get(tn);
            sField_TN_Handler.set(tn, (Object)new SafelyHandlerWrapper(preHandler));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SafelyHandlerWrapper
    extends Handler {
        private Handler impl;

        public SafelyHandlerWrapper(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                this.impl.dispatchMessage(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

