/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.view;

import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.component.imageview.Image;
import com.didi.hummer.component.list.List;
import com.didi.hummer.component.scroller.HorizontalScroller;
import com.didi.hummer.component.scroller.Scroller;
import com.didi.hummer.component.viewpager.ViewPager;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.HummerLayoutExtendView;
import com.didi.hummer.render.style.HummerLayout;

@Component(value="View")
public class View
extends HummerLayoutExtendView {
    private static final String OVERFLOW_VISIBLE = "visible";
    private static final String OVERFLOW_HIDDEN = "hidden";

    public View(HummerContext context, JSValue jsValue, String viewID) {
        super(context, jsValue, viewID);
    }

    @JsMethod(value="appendChild")
    public void appendChild(HMBase child) {
        super.appendChild(child);
        if (child == null) {
            return;
        }
        this.getNode().appendChild(child.getNode());
        if (child instanceof Image || child instanceof Scroller || child instanceof HorizontalScroller || child instanceof List || child instanceof ViewPager) {
            ((HummerLayout)this.getView()).setClipChildren(true);
        }
    }

    @JsMethod(value="removeChild")
    public void removeChild(HMBase child) {
        super.removeChild(child);
        if (child == null) {
            return;
        }
        this.getNode().removeChild(child.getNode());
    }

    @JsMethod(value="removeAll")
    public void removeAll() {
        super.removeAll();
        this.getNode().removeAll();
    }

    @JsMethod(value="insertBefore")
    public void insertBefore(HMBase child, HMBase existing) {
        super.insertBefore(child, existing);
        if (child == null || existing == null) {
            return;
        }
        this.getNode().insertBefore(child.getNode(), existing.getNode());
        if (child instanceof Image || child instanceof Scroller || child instanceof HorizontalScroller || child instanceof List || child instanceof ViewPager) {
            ((HummerLayout)this.getView()).setClipChildren(true);
        }
    }

    @JsMethod(value="replaceChild")
    public void replaceChild(HMBase child, HMBase old) {
        super.replaceChild(child, old);
        if (child == null || old == null) {
            return;
        }
        this.getNode().replaceChild(child.getNode(), old.getNode());
        if (child instanceof Image || child instanceof Scroller || child instanceof HorizontalScroller || child instanceof List || child instanceof ViewPager) {
            ((HummerLayout)this.getView()).setClipChildren(true);
        }
    }

    @Deprecated
    @JsMethod(value="getElementById")
    public HMBase getElementById(String viewID) {
        return super.getElementById(viewID);
    }

    @Deprecated
    @JsMethod(value="layout")
    public void layout() {
        ((HummerLayout)this.getView()).requestLayout();
    }

    @JsAttribute(value={"overflow"})
    public void setOverflow(String overflow) {
        boolean needClip = OVERFLOW_HIDDEN.equals(overflow);
        ((HummerLayout)this.getView()).setNeedClipChildren(needClip);
    }

    @JsMethod(value="empty")
    public void empty() {
    }

    public void resetStyle() {
        super.resetStyle();
        this.setOverflow(OVERFLOW_VISIBLE);
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "overflow": {
                this.setOverflow((String)value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

