/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.viewpager;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.imageloader.IImageLoaderAdapter;
import com.didi.hummer.component.viewpager.ReusePagerAdapter;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerNode;
import com.zhpan.bannerview.utils.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public class CyclePagerAdapter
extends ReusePagerAdapter<ViewHolder> {
    private Context mContext;
    private ObjectPool mInstanceManager;
    private List<Object> mList = new ArrayList<Object>();
    private boolean mIsCanLoop;
    private OnItemClickListener mOnItemClickListener;
    private JSCallback mOnItemViewCallback;
    public static final int MAX_VALUE = 100000;

    public CyclePagerAdapter(Context context, ObjectPool instanceManager) {
        this.mContext = context;
        this.mInstanceManager = instanceManager;
    }

    public void setData(List<Object> data) {
        this.mList = new ArrayList<Object>();
        this.mList.addAll(data);
        this.notifyDataSetChanged();
    }

    public void setCanLoop(boolean loop) {
        this.mIsCanLoop = loop;
    }

    public boolean isCanLoop() {
        return this.mIsCanLoop;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemViewCallback(JSCallback callback) {
        this.mOnItemViewCallback = callback;
    }

    private View makeDefaultImageView(int position) {
        Object obj = this.mList.get(position);
        if (obj == null) {
            return new View(this.mContext);
        }
        String url = obj.toString();
        if (TextUtils.isEmpty((CharSequence)url)) {
            return new View(this.mContext);
        }
        ImageView imageView = new ImageView(this.mContext);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        CyclePagerAdapter.getImageLoader((HummerContext)this.mContext).setImage(url, imageView);
        return imageView;
    }

    public int getRealPosition(int position) {
        return BannerUtils.getRealPosition((boolean)this.mIsCanLoop, (int)position, (int)this.mList.size());
    }

    private static IImageLoaderAdapter getImageLoader(HummerContext context) {
        return HummerAdapter.getImageLoaderAdapter((String)context.getNamespace());
    }

    @Override
    public int getItemCount() {
        if (this.mIsCanLoop && this.mList.size() > 1) {
            return 100000;
        }
        return this.mList.size();
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int position) {
        int realPosition = this.getRealPosition(position);
        if (this.mOnItemViewCallback == null) {
            return new ViewHolder(this.makeDefaultImageView(realPosition), null);
        }
        Object jsViewObj = this.mOnItemViewCallback.call(new Object[]{realPosition});
        if (!(jsViewObj instanceof JSValue)) {
            return new ViewHolder(this.makeDefaultImageView(realPosition), null);
        }
        JSValue jsView = (JSValue)jsViewObj;
        jsView.protect();
        HMBase view = (HMBase)this.mInstanceManager.get(jsView.getLong("objID"));
        if (view == null || view.getView() == null) {
            return new ViewHolder(this.makeDefaultImageView(realPosition), null);
        }
        return new ViewHolder(view.getView(), view);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.bind(this.getRealPosition(position));
    }

    public class ViewHolder
    extends ReusePagerAdapter.Holder {
        private boolean isJustCreated;
        private HMBase hmBase;
        private JSValue jsValue;
        private int position;

        public ViewHolder(View view, HMBase hmBase) {
            super(view);
            this.isJustCreated = true;
            this.hmBase = hmBase;
            this.jsValue = hmBase == null ? null : hmBase.getJSValue();
            this.itemView.setOnClickListener(v -> {
                if (CyclePagerAdapter.this.mOnItemClickListener != null) {
                    CyclePagerAdapter.this.mOnItemClickListener.onItemClick(this.position);
                }
            });
        }

        public void bind(int position) {
            String url;
            this.position = position;
            if (this.isJustCreated) {
                this.isJustCreated = false;
                return;
            }
            if (CyclePagerAdapter.this.mOnItemViewCallback != null && this.jsValue != null) {
                CyclePagerAdapter.this.mOnItemViewCallback.call(new Object[]{position, this.jsValue});
            } else if (this.itemView instanceof ImageView && !TextUtils.isEmpty((CharSequence)(url = CyclePagerAdapter.this.mList.get(position).toString()))) {
                CyclePagerAdapter.getImageLoader((HummerContext)CyclePagerAdapter.this.mContext).setImage(url, (ImageView)this.itemView);
            }
        }

        public HummerNode getNode() {
            return this.hmBase == null ? null : this.hmBase.getNode();
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

