/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.viewpager;

import android.view.View;
import com.zhpan.bannerview.transform.ScaleInTransformer;

public class ScaleAndAlphaTransformer
extends ScaleInTransformer {
    public static final float DEFAULT_MIN_ALPHA = 0.5f;
    public static final float MAX_ALPHA = 1.0f;
    private float mMinAlpha;

    public ScaleAndAlphaTransformer(float minScale, float minAlpha) {
        super(minScale);
        this.mMinAlpha = minAlpha;
    }

    public void transformPage(View view, float position) {
        super.transformPage(view, position);
        if (position < -1.0f || position > 1.0f) {
            view.setAlpha(this.mMinAlpha);
        } else if (position < 0.0f) {
            float alphaFactor = (1.0f + position) * (1.0f - this.mMinAlpha) + this.mMinAlpha;
            view.setAlpha(alphaFactor);
        } else {
            float alphaFactor = (1.0f - position) * (1.0f - this.mMinAlpha) + this.mMinAlpha;
            view.setAlpha(alphaFactor);
        }
    }
}

