/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.component.viewpager;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsAttribute;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.component.R;
import com.didi.hummer.component.viewpager.CyclePagerAdapter;
import com.didi.hummer.component.viewpager.ScaleAndAlphaTransformer;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.lifecycle.IFullLifeCycle;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerNode;
import com.didi.hummer.render.style.HummerStyleUtils;
import com.zhpan.bannerview.BannerViewPager;
import com.zhpan.bannerview.holder.ViewHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component(value="ViewPager")
public class ViewPager
extends HMBase<BannerViewPager<Object, ViewHolder>>
implements IFullLifeCycle {
    private static final String STYLE_ITEM_SPACING = "itemSpacing";
    private static final String STYLE_EDGE_SPACING = "edgeSpacing";
    private static final String STYLE_CAN_LOOP = "canLoop";
    private static final String STYLE_AUTO_PLAY = "autoPlay";
    private static final String STYLE_LOOP_INTERVAL = "loopInterval";
    private static final String STYLE_SCALE_FACTOR = "scaleFactor";
    private static final String STYLE_ALPHA_FACTOR = "alphaFactor";
    private CyclePagerAdapter adapter;
    private JSCallback mOnPageChangeListener;
    private JSCallback mOnPageScrollListener;
    private JSCallback mOnPageScrollStateChangeListener;
    private JSCallback mOnItemClickListener;
    private JSCallback mOnItemViewCallback;
    private float itemSpacing;
    private float edgeSpacing;
    private boolean canLoop;
    private boolean autoPlay;
    private int loopInterval;
    private float scaleFactor = 0.85f;
    private float alphaFactor = 0.5f;
    private int cornerRadius;
    private boolean isDataSetting;
    @JsProperty(value="data")
    public List<Object> mData = new ArrayList<Object>();

    public ViewPager(HummerContext context, JSValue jsValue) {
        super(context, jsValue, null);
        HummerStyleUtils.addNonDpStyle((String)STYLE_LOOP_INTERVAL);
        HummerStyleUtils.addNonDpStyle((String)STYLE_SCALE_FACTOR);
        HummerStyleUtils.addNonDpStyle((String)STYLE_ALPHA_FACTOR);
        ObjectPool instanceManager = context.getObjectPool();
        this.adapter = new CyclePagerAdapter((Context)context, instanceManager);
        this.adapter.setOnItemClickListener(position -> {
            int curIndex = ((BannerViewPager)this.getView()).getViewPager().getCurrentItem();
            if (position == (curIndex = this.adapter.getRealPosition(curIndex))) {
                if (this.mOnItemClickListener != null) {
                    this.mOnItemClickListener.call(new Object[]{position});
                }
            } else if (position == curIndex - 1 || position == curIndex + 1) {
                this.setCurrentItem(position);
            }
        });
        ((BannerViewPager)this.getView()).getViewPager().setOverScrollMode(2);
        ((BannerViewPager)this.getView()).setScrollDuration(1000).setCanLoop(false).setIndicatorVisibility(8).setHolderCreator(() -> new EmptyViewHolder()).setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (ViewPager.this.mOnPageScrollListener != null) {
                    if ((double)positionOffset >= 0.5) {
                        ++position;
                    }
                    ViewPager.this.mOnPageScrollListener.call(new Object[]{position, Float.valueOf(positionOffset)});
                }
            }

            public void onPageSelected(int position) {
                ViewPager.this.refreshNodeTree();
                if (ViewPager.this.mOnPageChangeListener != null && !ViewPager.this.isDataSetting) {
                    ViewPager.this.mOnPageChangeListener.call(new Object[]{position, ViewPager.this.mData.size()});
                }
            }

            public void onPageScrollStateChanged(int state) {
                if (ViewPager.this.mOnPageScrollStateChangeListener != null) {
                    ViewPager.this.mOnPageScrollStateChangeListener.call(new Object[]{state});
                }
            }
        });
    }

    protected BannerViewPager<Object, ViewHolder> createViewInstance(Context context) {
        return new BannerViewPager<Object, ViewHolder>(context){
            private int startX;
            private int startY;

            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (this.getCurrentItem() == 0 && this.getViewPager().getChildCount() == 0) {
                    return true;
                }
                this.processMotionEventConflict(ev);
                ev.offsetLocation(-ViewPager.this.edgeSpacing, 0.0f);
                try {
                    return this.getViewPager().dispatchTouchEvent(ev);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            }

            protected void processMotionEventConflict(MotionEvent ev) {
                switch (ev.getAction()) {
                    case 0: {
                        this.stopLoop();
                        this.startX = (int)ev.getX();
                        this.startY = (int)ev.getY();
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        break;
                    }
                    case 2: {
                        int endX = (int)ev.getX();
                        int endY = (int)ev.getY();
                        int disX = Math.abs(endX - this.startX);
                        int disY = Math.abs(endY - this.startY);
                        if (2 * disX >= disY) {
                            if (ViewPager.this.canLoop) break;
                            if (this.getViewPager().getCurrentItem() == 0 && endX - this.startX > 0) {
                                this.getParent().requestDisallowInterceptTouchEvent(false);
                                break;
                            }
                            if (this.getViewPager().getCurrentItem() != this.getList().size() - 1 || endX - this.startX >= 0) break;
                            this.getParent().requestDisallowInterceptTouchEvent(false);
                            break;
                        }
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.startLoop();
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                        break;
                    }
                    case 4: {
                        this.startLoop();
                    }
                }
            }
        };
    }

    public void onStart() {
    }

    public void onResume() {
        ((BannerViewPager)this.getView()).startLoop();
    }

    public void onPause() {
        ((BannerViewPager)this.getView()).stopLoop();
    }

    public void onStop() {
    }

    public void onStyleUpdated(Map<String, Object> style2) {
        this.initPageStyle();
    }

    private void initPageStyle() {
        boolean canAutoPlay;
        boolean bl = canAutoPlay = this.autoPlay && this.loopInterval > 0;
        if (!canAutoPlay) {
            ((BannerViewPager)this.getView()).stopLoop();
        }
        ((BannerViewPager)this.getView()).setPageStyle(this.edgeSpacing > 0.0f ? 2 : 0).setRevealWidth((int)(this.edgeSpacing - this.itemSpacing)).setAutoPlay(canAutoPlay).setInterval(this.loopInterval).setRoundCorner(this.cornerRadius);
        int pageMargin = (int)this.itemSpacing;
        if (pageMargin != ((BannerViewPager)this.getView()).getViewPager().getPageMargin()) {
            ((BannerViewPager)this.getView()).setPageMargin(pageMargin);
        }
        if (this.canLoop != this.adapter.isCanLoop()) {
            ((BannerViewPager)this.getView()).setCanLoop(this.canLoop);
            this.adapter.setCanLoop(this.canLoop);
            if (!this.mData.isEmpty()) {
                this.setData(this.mData);
            }
        }
    }

    public void setData(List<Object> data) {
        if (data == null) {
            data = new ArrayList<Object>();
        }
        if (!data.isEmpty() && !(data.get(0) instanceof String) && this.mOnItemViewCallback == null) {
            return;
        }
        this.isDataSetting = true;
        this.mData = data;
        ((BannerViewPager)this.getView()).create(data);
        if (this.edgeSpacing > 0.0f) {
            if (this.scaleFactor > 0.0f || this.alphaFactor > 0.0f) {
                ((BannerViewPager)this.getView()).setPageTransformer((ViewPager.PageTransformer)new ScaleAndAlphaTransformer(this.scaleFactor, this.alphaFactor));
            } else {
                ((BannerViewPager)this.getView()).setPageTransformer(null);
            }
        }
        this.adapter.setData(data);
        ((BannerViewPager)this.getView()).getViewPager().setAdapter((PagerAdapter)this.adapter);
        this.isDataSetting = false;
        this.setCurrentItem(0);
        this.refreshNodeTree();
    }

    @JsMethod(value="setCurrentItem")
    public void setCurrentItem(int position) {
        if (position < 0 || this.adapter.getItemCount() <= 0) {
            return;
        }
        position = Math.min(position, this.adapter.getItemCount() - 1);
        ((BannerViewPager)this.getView()).setCurrentItem(position);
    }

    @JsMethod(value="onPageChange")
    public void onPageChange(JSCallback callback) {
        this.mOnPageChangeListener = callback;
    }

    @JsMethod(value="onPageScroll")
    public void onPageScroll(JSCallback callback) {
        this.mOnPageScrollListener = callback;
    }

    @JsMethod(value="onPageScrollStateChange")
    public void onPageScrollStateChange(JSCallback callback) {
        this.mOnPageScrollStateChangeListener = callback;
    }

    @JsMethod(value="onItemClick")
    public void onItemClick(JSCallback callback) {
        this.mOnItemClickListener = callback;
    }

    @JsMethod(value="onItemView")
    public void onItemView(JSCallback callback) {
        this.mOnItemViewCallback = callback;
        this.adapter.setOnItemViewCallback(callback);
    }

    @JsMethod(value="dbg_getDescription")
    public void dbg_getDescription(JSCallback callback, int depth) {
        this.refreshNodeTree();
        super.dbg_getDescription(callback, depth);
    }

    private void refreshNodeTree() {
        if (!DebugUtil.isDebuggable()) {
            return;
        }
        ((BannerViewPager)this.getView()).post(() -> {
            this.getNode().removeAll();
            int count = Math.min(((BannerViewPager)this.getView()).getViewPager().getChildCount(), this.adapter.getItemCount());
            int curPosition = ((BannerViewPager)this.getView()).getCurrentItem();
            int firstPosition = count > 1 && curPosition > 0 ? curPosition - 1 : curPosition;
            int lastPosition = count > 1 && curPosition < count - 1 ? curPosition + 1 : curPosition;
            for (int i = firstPosition; i <= lastPosition; ++i) {
                HummerNode node;
                Object vh;
                View child = ((BannerViewPager)this.getView()).getViewPager().getChildAt(i);
                if (child == null || !((vh = ((BannerViewPager)this.getView()).getViewPager().getChildAt(i).getTag(R.id.holder_id)) instanceof CyclePagerAdapter.ViewHolder) || (node = ((CyclePagerAdapter.ViewHolder)vh).getNode()) == null) continue;
                node.setAlias(String.valueOf(i));
                this.getNode().appendChild(node);
            }
        });
    }

    @JsAttribute(value={"itemSpacing"})
    public void setItemSpacing(float spacing) {
        this.itemSpacing = spacing;
    }

    @JsAttribute(value={"edgeSpacing"})
    public void setEdgeSpacing(float spacing) {
        this.edgeSpacing = spacing;
    }

    @JsAttribute(value={"canLoop"})
    public void setCanLoop(boolean loop) {
        this.canLoop = loop;
    }

    @JsAttribute(value={"autoPlay"})
    public void setAutoPlay(boolean auto) {
        this.autoPlay = auto;
    }

    @JsAttribute(value={"loopInterval"})
    public void setLoopInterval(int interval) {
        this.loopInterval = interval;
    }

    @JsAttribute(value={"scaleFactor"})
    public void setScaleFactor(float factor) {
        this.scaleFactor = factor;
    }

    @JsAttribute(value={"alphaFactor"})
    public void setAlphaFactor(float factor) {
        this.alphaFactor = factor;
    }

    public void setBorderRadius(float radius) {
        this.cornerRadius = (int)radius;
    }

    public void resetStyle() {
        super.resetStyle();
        ((BannerViewPager)this.getView()).setPageStyle(0).setPageMargin(0).setRevealWidth(0).setCanLoop(false).setAutoPlay(false).setInterval(0).setRoundCorner(0).setPageTransformer(null);
        this.adapter.setCanLoop(false);
    }

    public boolean setStyle(String key, Object value) {
        switch (key) {
            case "itemSpacing": {
                this.setItemSpacing(((Float)value).floatValue());
                break;
            }
            case "edgeSpacing": {
                this.setEdgeSpacing(((Float)value).floatValue());
                break;
            }
            case "canLoop": {
                this.setCanLoop((Boolean)value);
                break;
            }
            case "autoPlay": {
                this.setAutoPlay((Boolean)value);
                break;
            }
            case "loopInterval": {
                this.setLoopInterval((int)((Float)value).floatValue());
                break;
            }
            case "scaleFactor": {
                this.setScaleFactor(((Float)value).floatValue());
                break;
            }
            case "alphaFactor": {
                this.setAlphaFactor(((Float)value).floatValue());
                break;
            }
            case "borderRadius": {
                if (!(value instanceof Float)) break;
                this.setBorderRadius(((Float)value).floatValue());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public class EmptyViewHolder
    implements ViewHolder<Object> {
        public int getLayoutId() {
            return R.layout.viewpager_empty_view;
        }

        public void onBind(View itemView, Object data, int position, int size) {
        }
    }
}

