/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.devtools.DevToolsConfig;
import com.didi.hummer.devtools.R;
import com.didi.hummer.devtools.invoker.HummerInvokerWrapper;
import com.didi.hummer.devtools.invoker.RequestInvokerWrapper;
import com.didi.hummer.devtools.manager.HummerLogManager;
import com.didi.hummer.devtools.manager.HummerNetManager;
import com.didi.hummer.devtools.widget.DevToolsEntrance;
import com.didi.hummer.devtools.widget.FloatLayout;
import com.didi.hummer.devtools.ws.WebSocketManager;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.Invoker;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;
import org.json.JSONException;
import org.json.JSONObject;

public class HummerDevTools {
    private HummerContext hmContext;
    private DevToolsEntrance entrance;
    private WebSocketManager wsManager;
    private HummerLogManager logManager;
    private HummerNetManager netManager;

    @Deprecated
    public static void init(HummerContext context) {
    }

    @Deprecated
    public static void init(HummerContext context, IParameterInjector injector) {
    }

    public HummerDevTools(HummerContext context) {
        this(context, null);
    }

    public HummerDevTools(HummerContext context, DevToolsConfig config) {
        this.hmContext = context;
        this.entrance = new DevToolsEntrance(context);
        this.wsManager = WebSocketManager.getInstance();
        this.logManager = new HummerLogManager();
        this.hmContext.registerInvoker((Invoker)new HummerInvokerWrapper(this.logManager));
        this.entrance.setLogManager(this.logManager);
        this.netManager = new HummerNetManager();
        this.hmContext.registerInvoker((Invoker)new RequestInvokerWrapper(this.netManager));
        this.entrance.setNetManager(this.netManager);
        if (config != null && config.getInjector() != null) {
            this.entrance.setParameterInjector(config.getInjector());
        }
    }

    public void release(HummerContext hmContext) {
        this.wsManager.release(hmContext.getPageUrl());
    }

    public void initConnection(HummerContext context, String url, IHotReloadCallback callback) {
        this.connectWebSocket(url, callback);
        this.initRefreshView(context, callback);
    }

    private void connectWebSocket(String url, IHotReloadCallback callback) {
        this.wsManager.connect(url, msg -> {
            msg = HummerDevTools.getUrlFromWS(msg);
            if (url != null && url.equalsIgnoreCase(msg) && callback != null) {
                callback.onHotReload();
            }
        });
    }

    private void initRefreshView(HummerContext context, IHotReloadCallback callback) {
        final FloatLayout floatLayout = new FloatLayout((Context)context);
        floatLayout.setOnClickListener(v -> {
            if (callback != null) {
                callback.onHotReload();
            }
        });
        ViewCompat.setElevation((View)floatLayout, (float)9000.0f);
        View.inflate((Context)context, (int)R.layout.layout_refresh_btn, (ViewGroup)floatLayout);
        HMBase<FloatLayout> base = new HMBase<FloatLayout>(context, null, null){

            protected FloatLayout createViewInstance(Context context) {
                return floatLayout;
            }
        };
        base.getYogaNode().setPositionType(YogaPositionType.ABSOLUTE);
        base.getYogaNode().setPosition(YogaEdge.END, 0.0f);
        base.getYogaNode().setPositionPercent(YogaEdge.BOTTOM, 50.0f);
        context.getContainer().addView((HMBase)base);
    }

    private static String getUrlFromWS(String wsMsg) {
        if (TextUtils.isEmpty((CharSequence)wsMsg)) {
            return null;
        }
        String url = null;
        try {
            JSONObject jo = new JSONObject(wsMsg);
            url = jo.getJSONObject("params").getString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(url)) {
            return null;
        }
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        return url;
    }

    public static interface IHotReloadCallback {
        public void onHotReload();
    }

    public static interface IParameterInjector {
        public void injectParameter(StringBuilder var1);
    }
}

