/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.bean;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class LogBean
implements Serializable {
    public static final int LEVEL_LOG = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_WARN = 4;
    public static final int LEVEL_ERROR = 5;
    @SerializedName(value="level")
    private int level;
    @SerializedName(value="message")
    private String msg;
    private transient String rawMsg;
    private transient long timestamp;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");

    public LogBean(int level, String msg) {
        this.level = level;
        this.rawMsg = msg;
        this.timestamp = System.currentTimeMillis();
        String time = DATE_FORMAT.format(this.timestamp);
        this.msg = String.format("[%s] %s", time, msg);
    }

    public int getLevel() {
        return this.level;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getRawMsg() {
        return this.rawMsg;
    }
}

