/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.manager;

import com.didi.hummer.core.util.HMGsonUtil;
import com.didi.hummer.devtools.bean.LogBean;
import com.didi.hummer.devtools.bean.WSMsg;
import com.didi.hummer.devtools.ws.WebSocketManager;
import java.util.ArrayList;
import java.util.List;

public class HummerLogManager {
    private List<LogBean> logs = new ArrayList<LogBean>();
    private ILogListener mListener;

    public void registerListener(ILogListener listener) {
        this.mListener = listener;
    }

    public List<LogBean> getLogs() {
        return this.logs;
    }

    public void addLog(int level, String msg) {
        LogBean bean = new LogBean(level, msg);
        this.logs.add(bean);
        if (this.mListener != null) {
            this.mListener.onLogAdd(bean);
        }
        this.sendLog2Cli(bean);
    }

    public void sendLog2Cli(LogBean bean) {
        WSMsg<LogBean> wsMsg = new WSMsg<LogBean>("log", bean);
        WebSocketManager.getInstance().sendMsg(HMGsonUtil.toJson(wsMsg));
    }

    public static interface ILogListener {
        public void onLogAdd(LogBean var1);
    }
}

