/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.utils;

import com.didi.hummer.debug.InvokeTracker;
import java.util.Arrays;
import java.util.List;

public class CallStackFormat {
    public static String format(List<InvokeTracker> trackerList) {
        if (trackerList == null || trackerList.isEmpty()) {
            return "";
        }
        return "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u2502\t\u51fd\u6570\u8c03\u7528\u6808\n\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + CallStackFormat.generateCallStackInfo(trackerList) + "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n";
    }

    private static String generateCallStackInfo(List<InvokeTracker> trackerList) {
        if (trackerList == null || trackerList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (InvokeTracker t : trackerList) {
            if (t.methodName.equals("constructor_end")) continue;
            sb.append("\u2502\t").append(String.format("[%s] (%d) %s.%s(%s)\n", t.timeFormat, t.objectID, t.className, t.methodName, t.params.length > 0 ? Arrays.toString(t.params) : ""));
        }
        return sb.toString();
    }
}

