/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.utils;

import android.text.TextUtils;
import com.didi.hummer.render.style.HummerNode;
import java.util.Iterator;

public class ComponentTreeFormat {
    private static final String FORMAT_STRING_LEFT_TOP = "\u250c\u2500";
    private static final String FORMAT_STRING_LEFT_CENTER = "\u251c\u2500";
    private static final String FORMAT_STRING_LEFT_BOTTOM = "\u2514\u2500";
    private static final String FORMAT_STRING_NORMAL_H = "\u2500";
    private static final String FORMAT_STRING_NORMAL_V = "\u2502";

    public static String format(HummerNode node) {
        if (node == null) {
            return "";
        }
        return "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u2502\t\u89c6\u56fe\u6811\n\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + ComponentTreeFormat.generateNodeTreeInfo(node, 0, 0) + "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n";
    }

    private static String generateNodeTreeInfo(HummerNode node, int level, int lastNodeFlag) {
        if (node == null) {
            return "";
        }
        StringBuilder strLog = new StringBuilder();
        strLog.append("\u2502\t").append(ComponentTreeFormat.generateTabFormatString(level, lastNodeFlag));
        if (node.getObjId() >= 0L) {
            strLog.append(node.getObjId()).append(".");
        }
        strLog.append(node.getName());
        if (!TextUtils.isEmpty((CharSequence)node.getContent())) {
            strLog.append(" (").append(node.getContent()).append(")");
        }
        strLog.append('\n');
        if (node.getChildren() != null && !node.getChildren().isEmpty()) {
            int newLevel = level + 1;
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                boolean isLastNode;
                HummerNode n = (HummerNode)it.next();
                boolean bl = isLastNode = !it.hasNext();
                if (isLastNode) {
                    lastNodeFlag |= 1 << level;
                }
                strLog.append(ComponentTreeFormat.generateNodeTreeInfo(n, newLevel, lastNodeFlag));
            }
        }
        return strLog.toString();
    }

    private static String generateTabFormatString(int count, int lastNodeFlag) {
        StringBuilder tabStr = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if ((lastNodeFlag & 1 << i) == 0) {
                if (i < count - 1) {
                    tabStr.append("\u2502\t");
                    continue;
                }
                tabStr.append(FORMAT_STRING_LEFT_CENTER);
                continue;
            }
            if (i < count - 1) {
                tabStr.append("\t");
                continue;
            }
            tabStr.append(FORMAT_STRING_LEFT_BOTTOM);
        }
        if (tabStr.length() > 0) {
            tabStr.append(" ");
        }
        return tabStr.toString();
    }
}

