/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.utils;

import com.didi.hummer.debug.InvokeTracker;
import com.didi.hummer.debug.PerformanceTracker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PerformanceListFormat {
    public static String format(List<PerformanceTracker> perfTrackerList) {
        if (perfTrackerList == null || perfTrackerList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PerformanceTracker tracker : perfTrackerList) {
            sb.append(PerformanceListFormat.generatePerformanceFormat(tracker));
        }
        return sb.toString();
    }

    private static String generatePerformanceFormat(PerformanceTracker tracker) {
        return "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u2502\t\u8017\u65f6\u7edf\u8ba1\n\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + PerformanceListFormat.generateSourceCallStackInfo(tracker) + "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + PerformanceListFormat.generateSummaryPerformanceInfo(tracker) + "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + PerformanceListFormat.generateInvokeTimeCostSortInfo(tracker) + "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\n" + PerformanceListFormat.generateInvokeCallStackInfo(tracker) + "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\n";
    }

    private static String generateSourceCallStackInfo(PerformanceTracker tracker) {
        if (tracker == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u2502\t<Source Call Stack>\n");
        for (String stack : tracker.sourceCallStack) {
            sb.append("\u2502\t" + stack + "\n");
        }
        return sb.toString();
    }

    private static String generateSummaryPerformanceInfo(PerformanceTracker tracker) {
        if (tracker == null) {
            return "";
        }
        return "\u2502\t" + String.format("totalCost: %d ms\n", tracker.totalCost / 1000000L) + "\u2502\t" + String.format("invokeCost: %d ms\n", tracker.invokeCost / 1000000L) + "\u2502\t" + String.format("otherCost: %d ms\n", tracker.otherCost / 1000000L);
    }

    private static String generateInvokeTimeCostSortInfo(PerformanceTracker tracker) {
        if (tracker == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : tracker.sortTimeCostList) {
            String funcName = (String)entry.getKey();
            PerformanceTracker.TimeCost costTime = (PerformanceTracker.TimeCost)entry.getValue();
            if (funcName.contains("constructor_end")) continue;
            sb.append("\u2502\t").append(String.format("[%.1f ms] %s - {%d}\n", Float.valueOf((float)costTime.cost / 1000000.0f), funcName, costTime.count));
        }
        return sb.toString();
    }

    private static String generateInvokeCallStackInfo(PerformanceTracker tracker) {
        if (tracker == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (InvokeTracker t : tracker.trackerList) {
            if (t.methodName.equals("constructor_end")) continue;
            sb.append("\u2502\t").append(String.format("[%s] (%d) %s.%s(%s)\n", t.timeFormat, t.objectID, t.className, t.methodName, t.params.length > 0 ? Arrays.toString(t.params) : ""));
        }
        return sb.toString();
    }
}

