/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.widget;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.method.ScrollingMovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.devtools.HummerDevTools;
import com.didi.hummer.devtools.R;
import com.didi.hummer.devtools.bean.LogBean;
import com.didi.hummer.devtools.bean.NetBean;
import com.didi.hummer.devtools.manager.HummerLogManager;
import com.didi.hummer.devtools.manager.HummerNetManager;
import com.didi.hummer.devtools.utils.CallStackFormat;
import com.didi.hummer.devtools.utils.ComponentTreeFormat;
import com.didi.hummer.devtools.utils.JSONFormat;
import com.didi.hummer.devtools.utils.PerformanceListFormat;
import com.didi.hummer.render.style.HummerNode;
import com.didi.hummer.render.utility.DPUtil;
import com.didi.hummer.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.List;

public class ConsoleView
extends FrameLayout
implements HummerLogManager.ILogListener {
    private List<LogBean> logs = new ArrayList<LogBean>();
    private View layoutConsole;
    private View btnClearLog;
    private RecyclerView rvConsole;
    private ViewGroup layoutInfo;
    private ScrollView scrollInfo;
    private TextView tvInfo;
    private View tabConsole;
    private View tabParams;
    private View tabCompTree;
    private View tabCallStack;
    private View tabPerformance;
    private View tabNet;
    private HummerContext hummerContext;
    private HummerDevTools.IParameterInjector mInjector;
    private int curTabIndex;
    private List<NetBean> mNets = new ArrayList<NetBean>();
    RecyclerView.Adapter<ConsoleHolder> mAdapter = new RecyclerView.Adapter<ConsoleHolder>(){

        @NonNull
        public ConsoleHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int type) {
            return new ConsoleHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.layout_console_item, viewGroup, false));
        }

        public void onBindViewHolder(@NonNull ConsoleHolder viewHolder, int position) {
            viewHolder.updateUI(position);
        }

        public int getItemCount() {
            return ConsoleView.this.logs.size();
        }
    };

    public ConsoleView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public ConsoleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        switch (this.curTabIndex) {
            case 1: {
                this.updateParameters();
                break;
            }
            case 2: {
                this.updateCompTree();
                break;
            }
            case 3: {
                this.updateCallStack();
                break;
            }
            case 4: {
                this.updatePerformance();
                break;
            }
            case 5: {
                this.updateNet();
                break;
            }
        }
    }

    public void bindHummerContext(HummerContext context) {
        this.hummerContext = context;
    }

    public void bindParameterInjector(HummerDevTools.IParameterInjector injector) {
        this.mInjector = injector;
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_console_container, (ViewGroup)this);
        this.layoutConsole = this.findViewById(R.id.layout_console);
        this.btnClearLog = this.findViewById(R.id.btn_clear_log);
        this.btnClearLog.setOnClickListener(v -> this.clearData());
        this.rvConsole = (RecyclerView)this.findViewById(R.id.rv_console);
        this.rvConsole.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.rvConsole.setAdapter(this.mAdapter);
        this.layoutInfo = (ViewGroup)this.findViewById(R.id.layout_info);
        this.scrollInfo = (ScrollView)this.findViewById(R.id.layout_info_v);
        this.tvInfo = (TextView)this.findViewById(R.id.tv_info);
        this.tvInfo.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.tvInfo.setOnLongClickListener(v -> {
            this.copyToClipboard(this.tvInfo.getContext(), this.tvInfo.getText().toString());
            Toast.makeText((Context)this.tvInfo.getContext(), (CharSequence)"\u5185\u5bb9\u5df2\u590d\u5236", (int)0).show();
            return true;
        });
        this.tabConsole = this.findViewById(R.id.tab_console);
        this.tabConsole.setSelected(true);
        this.tabConsole.setOnClickListener(v -> {
            this.curTabIndex = 0;
            this.layoutInfo.setVisibility(8);
            this.layoutConsole.setVisibility(0);
            this.tabConsole.setSelected(true);
            this.tabParams.setSelected(false);
            this.tabCompTree.setSelected(false);
            this.tabCallStack.setSelected(false);
            this.tabPerformance.setSelected(false);
            this.tabNet.setSelected(false);
        });
        this.tabParams = this.findViewById(R.id.tab_params);
        this.tabParams.setOnClickListener(v -> {
            this.curTabIndex = 1;
            this.layoutInfo.setVisibility(0);
            this.layoutConsole.setVisibility(8);
            this.tabConsole.setSelected(false);
            this.tabParams.setSelected(true);
            this.tabCompTree.setSelected(false);
            this.tabCallStack.setSelected(false);
            this.tabPerformance.setSelected(false);
            this.tabNet.setSelected(false);
            this.updateParameters();
        });
        this.tabCompTree = this.findViewById(R.id.tab_comp_tree);
        this.tabCompTree.setOnClickListener(v -> {
            this.curTabIndex = 2;
            this.layoutInfo.setVisibility(0);
            this.layoutConsole.setVisibility(8);
            this.tabConsole.setSelected(false);
            this.tabParams.setSelected(false);
            this.tabCompTree.setSelected(true);
            this.tabCallStack.setSelected(false);
            this.tabPerformance.setSelected(false);
            this.tabNet.setSelected(false);
            this.updateCompTree();
        });
        this.tabCallStack = this.findViewById(R.id.tab_call_stack);
        this.tabCallStack.setOnClickListener(v -> {
            this.curTabIndex = 3;
            this.layoutInfo.setVisibility(0);
            this.layoutConsole.setVisibility(8);
            this.tabConsole.setSelected(false);
            this.tabParams.setSelected(false);
            this.tabCompTree.setSelected(false);
            this.tabCallStack.setSelected(true);
            this.tabPerformance.setSelected(false);
            this.tabNet.setSelected(false);
            this.updateCallStack();
        });
        this.tabPerformance = this.findViewById(R.id.tab_performance);
        this.tabPerformance.setOnClickListener(v -> {
            this.curTabIndex = 4;
            this.layoutInfo.setVisibility(0);
            this.layoutConsole.setVisibility(8);
            this.tabConsole.setSelected(false);
            this.tabParams.setSelected(false);
            this.tabCompTree.setSelected(false);
            this.tabCallStack.setSelected(false);
            this.tabPerformance.setSelected(true);
            this.tabNet.setSelected(false);
            this.updatePerformance();
        });
        this.tabNet = this.findViewById(R.id.tab_net);
        this.tabNet.setOnClickListener(v -> {
            this.curTabIndex = 5;
            this.layoutInfo.setVisibility(0);
            this.layoutConsole.setVisibility(8);
            this.tabConsole.setSelected(false);
            this.tabParams.setSelected(false);
            this.tabCompTree.setSelected(false);
            this.tabCallStack.setSelected(false);
            this.tabPerformance.setSelected(false);
            this.tabNet.setSelected(true);
            this.updateNet();
        });
    }

    private void updateParameters() {
        Object pageResult;
        Object pageInfo;
        StringBuilder builder = new StringBuilder();
        builder.append("Hummer SDK Version: ");
        builder.append("0.4.5");
        builder.append("\n\n\n");
        Object env = this.hummerContext.getJsContext().evaluateJavaScript("JSON.stringify(Hummer.env)");
        if (env != null) {
            builder.append("Hummer.env: ");
            builder.append(JSONFormat.format(String.valueOf(env)));
            builder.append("\n\n\n");
        }
        if ((pageInfo = this.hummerContext.getJsContext().evaluateJavaScript("JSON.stringify(Hummer.pageInfo)")) != null) {
            builder.append("Hummer.pageInfo: ");
            builder.append(JSONFormat.format(String.valueOf(pageInfo)));
            builder.append("\n\n\n");
        }
        if ((pageResult = this.hummerContext.getJsContext().evaluateJavaScript("JSON.stringify(Hummer.pageResult)")) != null) {
            builder.append("Hummer.pageResult: ");
            builder.append(JSONFormat.format(String.valueOf(pageResult)));
            builder.append("\n\n\n");
        }
        if (this.mInjector != null) {
            this.mInjector.injectParameter(builder);
        }
        this.tvInfo.setText((CharSequence)builder.toString());
    }

    private void updateCompTree() {
        HummerNode node = this.hummerContext.getJSRootView() != null ? this.hummerContext.getJSRootView().getNode() : null;
        this.tvInfo.setText((CharSequence)ComponentTreeFormat.format(node));
        this.scrollInfo.post(() -> this.scrollInfo.fullScroll(130));
    }

    private void updateCallStack() {
        List trackerList = this.hummerContext.getInvokerAnalyzer() != null ? this.hummerContext.getInvokerAnalyzer().getInvokeTrackerList() : null;
        this.tvInfo.setText((CharSequence)CallStackFormat.format(trackerList));
        this.scrollInfo.post(() -> this.scrollInfo.fullScroll(130));
    }

    private void updatePerformance() {
        List perfTrackerList = this.hummerContext.getInvokerAnalyzer() != null ? this.hummerContext.getInvokerAnalyzer().getPerfTrackerList() : null;
        String info = PerformanceListFormat.format(perfTrackerList);
        this.tvInfo.setText((CharSequence)info);
    }

    public void bindLog(HummerLogManager logManager) {
        logManager.registerListener(this);
        this.setData(logManager.getLogs());
    }

    public void addLog(LogBean log) {
        this.logs.add(log);
        this.mAdapter.notifyItemInserted(this.logs.size() - 1);
        this.rvConsole.scrollToPosition(this.logs.size() - 1);
    }

    public void setData(List<LogBean> logs) {
        this.logs.addAll(logs);
        this.mAdapter.notifyDataSetChanged();
        this.rvConsole.scrollToPosition(logs.size() - 1);
    }

    public void clearData() {
        this.logs.clear();
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onLogAdd(LogBean log) {
        this.post(() -> this.addLog(log));
    }

    private void copyToClipboard(Context context, String strCopy) {
        ClipboardManager cm = (ClipboardManager)context.getSystemService("clipboard");
        if (cm != null) {
            cm.setPrimaryClip(ClipData.newPlainText((CharSequence)"Label", (CharSequence)strCopy));
        }
    }

    public void bindNet(HummerNetManager netManager) {
        this.mNets = netManager.getNets();
        this.updateNet();
    }

    private void updateNet() {
        StringBuilder builder = new StringBuilder();
        if (this.mNets != null) {
            int size = this.mNets.size();
            for (int i = 0; i < size; ++i) {
                NetBean net = this.mNets.get(i);
                int index = i + 1;
                builder.append("\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                builder.append(index);
                builder.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                builder.append("\tUrl:\n");
                builder.append("\t");
                builder.append(net.getUrl());
                builder.append("\n\n");
                builder.append("\tData: \n");
                builder.append("\t");
                if (net.getData() == null) {
                    builder.append("null");
                } else {
                    builder.append(JSONFormat.format(net.getData().toString()));
                }
                builder.append("\n\n");
                builder.append("\tError: \n");
                builder.append("\t");
                if (net.getError() == null) {
                    builder.append("null");
                } else {
                    builder.append(net.getError().toString());
                }
                builder.append("\n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                builder.append(index);
                builder.append("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\n");
            }
        }
        this.tvInfo.setText((CharSequence)builder.toString());
    }

    private class ConsoleHolder
    extends RecyclerView.ViewHolder {
        TextView tvConsole;

        ConsoleHolder(View itemView) {
            super(itemView);
            itemView.setMinimumWidth(ScreenUtils.getScreenWidth((Context)itemView.getContext()) - DPUtil.dp2px((Context)itemView.getContext(), (float)24.0f));
            this.tvConsole = (TextView)itemView.findViewById(R.id.tv_debug_console);
            itemView.setOnLongClickListener(v -> {
                ConsoleView.this.copyToClipboard(this.tvConsole.getContext(), this.tvConsole.getText().toString());
                Toast.makeText((Context)this.tvConsole.getContext(), (CharSequence)"\u5185\u5bb9\u5df2\u590d\u5236", (int)0).show();
                return true;
            });
        }

        public void updateUI(int position) {
            LogBean bean = (LogBean)ConsoleView.this.logs.get(position);
            switch (bean.getLevel()) {
                case 1: 
                case 2: 
                case 3: {
                    this.tvConsole.setTextColor(-16777216);
                    break;
                }
                case 4: {
                    this.tvConsole.setTextColor(-168640);
                    break;
                }
                case 5: {
                    this.tvConsole.setTextColor(-65536);
                    break;
                }
                default: {
                    this.tvConsole.setTextColor(-16777216);
                }
            }
            this.tvConsole.setText((CharSequence)bean.getMsg());
        }
    }
}

