/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.devtools.HummerDevTools;
import com.didi.hummer.devtools.R;
import com.didi.hummer.devtools.manager.HummerLogManager;
import com.didi.hummer.devtools.manager.HummerNetManager;
import com.didi.hummer.devtools.widget.ConsoleView;
import com.didi.hummer.devtools.widget.FloatLayout;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.style.HummerLayout;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaPositionType;

public class DevToolsEntrance {
    private HummerContext mHummerContext;
    private JSContext mJsContext;
    private HummerLayout mContainer;
    private View mLayoutDevtools;
    private HMBase mConsoleView;
    private HummerLogManager mLogManager;
    private HummerDevTools.IParameterInjector mParameterInjector;
    private HummerNetManager mNetManager;
    private boolean mIsShown;

    public DevToolsEntrance(@NonNull HummerContext context) {
        this.mHummerContext = context;
        this.mJsContext = this.mHummerContext.getJsContext();
        this.mContainer = this.mHummerContext.getContainer();
        this.initView((Context)context);
    }

    private void initView(Context context) {
        final FloatLayout floatLayout = new FloatLayout(context);
        ViewCompat.setElevation((View)floatLayout, (float)10000.0f);
        floatLayout.setOnClickListener(v -> {
            if (!this.mIsShown) {
                this.openConsoleView();
            } else {
                this.closeConsoleView();
            }
        });
        this.mLayoutDevtools = View.inflate((Context)context, (int)R.layout.layout_devtools_btn, (ViewGroup)floatLayout);
        this.mLayoutDevtools.setFocusableInTouchMode(true);
        this.mLayoutDevtools.setOnKeyListener((v, keyCode, event) -> {
            if (keyCode == 4 && event.getAction() == 1 && this.mIsShown) {
                this.closeConsoleView();
                return true;
            }
            return false;
        });
        TextView tvJsEngine = (TextView)this.mLayoutDevtools.findViewById(R.id.tv_js_engine);
        tvJsEngine.setText((CharSequence)this.getJsEngineString());
        HMBase<FloatLayout> base = new HMBase<FloatLayout>(this.mHummerContext, null, null){

            protected FloatLayout createViewInstance(Context context) {
                return floatLayout;
            }
        };
        base.getYogaNode().setPositionType(YogaPositionType.ABSOLUTE);
        base.getYogaNode().setPosition(YogaEdge.END, 0.0f);
        base.getYogaNode().setPositionPercent(YogaEdge.BOTTOM, 20.0f);
        this.mContainer.addView((HMBase)base);
    }

    public void setParameterInjector(HummerDevTools.IParameterInjector injector) {
        this.mParameterInjector = injector;
    }

    public void setLogManager(HummerLogManager manager) {
        this.mLogManager = manager;
    }

    public void setNetManager(HummerNetManager manager) {
        this.mNetManager = manager;
    }

    @SuppressLint(value={"SwitchIntDef"})
    public String getJsEngineString() {
        String className;
        switch (className = this.mHummerContext.getClass().getSimpleName()) {
            case "JSCHummerContext": {
                int engine = HummerSDK.getJsEngine();
                switch (engine) {
                    case 1: {
                        return "JSC";
                    }
                    case 4: {
                        return "Hermes";
                    }
                    case 2: {
                        return "QuickJS";
                    }
                }
                return "Unknown";
            }
            case "NAPIHummerContext": {
                int engine = HummerSDK.getJsEngine();
                switch (engine) {
                    case 5: {
                        return "NAPI - QuickJS";
                    }
                    case 6: {
                        return "NAPI - Hermes";
                    }
                }
                return "Unknown";
            }
            case "V8HummerContext": {
                return "V8";
            }
        }
        return "Unknown";
    }

    private void openConsoleView() {
        this.mIsShown = true;
        if (this.mConsoleView == null) {
            this.initConsoleView();
        }
        this.mContainer.addView(this.mConsoleView);
        this.mLayoutDevtools.requestFocus();
    }

    private void closeConsoleView() {
        this.mIsShown = false;
        this.mContainer.removeView(this.mConsoleView);
    }

    private void initConsoleView() {
        final ConsoleView view = new ConsoleView((Context)this.mHummerContext);
        view.bindHummerContext(this.mHummerContext);
        view.bindParameterInjector(this.mParameterInjector);
        view.bindLog(this.mLogManager);
        view.bindNet(this.mNetManager);
        ViewCompat.setElevation((View)view, (float)9999.0f);
        this.mConsoleView = new HMBase<ConsoleView>(this.mHummerContext, null, null){

            protected ConsoleView createViewInstance(Context context) {
                return view;
            }
        };
        this.mConsoleView.getYogaNode().setPositionType(YogaPositionType.ABSOLUTE);
        this.mConsoleView.getYogaNode().setWidthPercent(100.0f);
        this.mConsoleView.getYogaNode().setHeightPercent(100.0f);
    }
}

