/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.didi.hummer.utils.BarUtils;
import com.didi.hummer.utils.ScreenUtils;

public class FloatLayout
extends FrameLayout {
    private int statusBarHeight;
    private int maxWidth;
    private int maxHeight;
    private int viewWidth;
    private int viewHeight;
    private float lastX;
    private float lastY;
    private long touchDownTimestamp;

    public FloatLayout(Context context) {
        this(context, null);
    }

    public FloatLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.statusBarHeight = BarUtils.getStatusBarHeight((Context)this.getContext());
        this.maxWidth = ScreenUtils.getScreenWidth((Context)context);
        this.maxHeight = ScreenUtils.getScreenHeight((Context)context) - this.statusBarHeight - BarUtils.getNavBarHeight((Context)context);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.clearAnimation();
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                this.viewWidth = this.getWidth();
                this.viewHeight = this.getHeight();
                if (this.getParent() != null && this.getParent() instanceof View) {
                    this.maxWidth = ((View)this.getParent()).getWidth();
                    this.maxHeight = ((View)this.getParent()).getHeight();
                }
                this.touchDownTimestamp = System.currentTimeMillis();
                break;
            }
            case 2: {
                float moveX = event.getRawX() - this.lastX;
                float moveY = event.getRawY() - this.lastY;
                float viewX = this.getX() + moveX;
                float viewY = this.getY() + moveY;
                float f = viewX < 0.0f ? 0.0f : (viewX = viewX + (float)this.viewWidth > (float)this.maxWidth ? (float)(this.maxWidth - this.viewWidth) : viewX);
                viewY = viewY < 0.0f ? 0.0f : (viewY + (float)this.viewHeight > (float)this.maxHeight ? (float)(this.maxHeight - this.viewHeight) : viewY);
                this.setX(viewX);
                this.setY(viewY);
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                break;
            }
            case 1: {
                float centerX = this.getX() + (float)this.viewWidth / 2.0f;
                if (centerX > (float)this.maxWidth / 2.0f) {
                    this.animate().setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(200L).xBy((float)(this.maxWidth - this.viewWidth) - this.getX()).start();
                } else {
                    this.animate().setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(200L).x(0.0f).start();
                }
                if (System.currentTimeMillis() - this.touchDownTimestamp >= 200L) break;
                this.performClick();
                break;
            }
        }
        return true;
    }
}

