/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.devtools.ws;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class WebSocketManager {
    private static final int RECONNECT_DELAY_MS = 2000;
    private static volatile WebSocketManager instance = null;
    private static OkHttpClient client;
    private WebSocket webSocket;
    private String mWsUrl;
    private Handler mHandler;
    private boolean mClosed;
    private boolean mIsReconnectWaiting;
    private Map<String, WSMsgListener> wsMsgListeners = new HashMap<String, WSMsgListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebSocketManager getInstance() {
        if (instance != null) return instance;
        Class<WebSocketManager> clazz = WebSocketManager.class;
        synchronized (WebSocketManager.class) {
            if (instance != null) return instance;
            instance = new WebSocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WebSocketManager() {
        this.mHandler = new Handler(Looper.getMainLooper());
        if (client == null) {
            client = new OkHttpClient();
        }
    }

    public void connect(String url, WSMsgListener listener) {
        if (!this.wsMsgListeners.containsKey(url)) {
            this.wsMsgListeners.put(url, listener);
        }
        if (this.webSocket != null) {
            return;
        }
        this.mWsUrl = this.toWSUrl(url);
        this.doConnect();
    }

    private void doConnect() {
        if (TextUtils.isEmpty((CharSequence)this.mWsUrl)) {
            return;
        }
        Request request = new Request.Builder().url(this.mWsUrl).build();
        client.newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketManager.this.webSocket = webSocket;
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                if (!WebSocketManager.this.mClosed) {
                    WebSocketManager.this.reconnect();
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                t.printStackTrace();
                if (!WebSocketManager.this.mClosed) {
                    WebSocketManager.this.reconnect();
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                WebSocketManager.this.mHandler.post(() -> {
                    for (String url : WebSocketManager.this.wsMsgListeners.keySet()) {
                        WSMsgListener l = (WSMsgListener)WebSocketManager.this.wsMsgListeners.get(url);
                        if (l == null) continue;
                        l.onMsgReceived(text);
                    }
                });
            }
        });
    }

    private void reconnect() {
        if (this.mClosed || this.mIsReconnectWaiting) {
            return;
        }
        this.mIsReconnectWaiting = true;
        this.mHandler.postDelayed(() -> {
            if (!this.mClosed) {
                this.doConnect();
            }
            this.mIsReconnectWaiting = false;
        }, 2000L);
    }

    public void sendMsg(String msg) {
        if (this.webSocket != null) {
            this.webSocket.send(msg);
        }
    }

    public void release(String url) {
        this.wsMsgListeners.remove(url);
    }

    private void close() {
        this.mClosed = true;
        if (this.webSocket != null) {
            try {
                this.webSocket.close(1000, "End of session");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.webSocket = null;
        }
    }

    private String toWSUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (!(url = url.toLowerCase()).startsWith("http://")) {
            if (url.startsWith("ws://")) {
                return url;
            }
            return null;
        }
        Uri uri = Uri.parse((String)url);
        return "ws://" + uri.getAuthority() + "/proxy/native";
    }

    public static interface WSMsgListener {
        public void onMsgReceived(String var1);
    }
}

