/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer;

import com.didi.hummer.adapter.font.IFontAdapter;
import com.didi.hummer.adapter.font.impl.DefaultFontAdapter;
import com.didi.hummer.adapter.http.IHttpAdapter;
import com.didi.hummer.adapter.http.impl.DefaultHttpAdapter;
import com.didi.hummer.adapter.imageloader.IImageLoaderAdapter;
import com.didi.hummer.adapter.imageloader.impl.DefaultImageLoaderAdapter;
import com.didi.hummer.adapter.navigator.INavigatorAdapter;
import com.didi.hummer.adapter.navigator.impl.DefaultNavigatorAdapter;
import com.didi.hummer.adapter.scriptloader.IScriptLoaderAdapter;
import com.didi.hummer.adapter.scriptloader.impl.DefaultScriptLoaderAdapter;
import com.didi.hummer.adapter.storage.IStorageAdapter;
import com.didi.hummer.adapter.storage.impl.DefaultStorageAdapter;
import com.didi.hummer.adapter.tracker.ITrackerAdapter;
import com.didi.hummer.adapter.tracker.impl.EmptyTrackerAdapter;
import com.didi.hummer.core.exception.ExceptionCallback;
import com.didi.hummer.meta.ComponentInvokerIndex;
import com.didi.hummer.tools.EventTracer;
import com.didi.hummer.tools.JSLogger;
import java.util.ArrayList;
import java.util.List;

public class HummerConfig {
    private String namespace;
    private JSLogger.Logger jsLogger;
    private EventTracer.Trace eventTracer;
    private ExceptionCallback exceptionCallback;
    private boolean isSupportRTL;
    private boolean isSupportBytecode;
    private String fontsAssetsPath;
    private IHttpAdapter httpAdapter;
    private IFontAdapter fontAdapter;
    private IImageLoaderAdapter imageLoaderAdapter;
    private IStorageAdapter storageAdapter;
    private INavigatorAdapter navAdapter;
    private IScriptLoaderAdapter scriptLoaderAdapter;
    private ITrackerAdapter trackerAdapter;
    private List<ComponentInvokerIndex> componentInvokerIndexes;

    private HummerConfig(Builder builder) {
        this.namespace = builder.namespace;
        this.jsLogger = builder.jsLogger;
        this.eventTracer = builder.eventTracer;
        this.exceptionCallback = builder.exceptionCallback;
        this.isSupportRTL = builder.isSupportRTL;
        this.isSupportBytecode = builder.isSupportBytecode;
        this.fontsAssetsPath = builder.fontsAssetsPath;
        this.httpAdapter = builder.httpAdapter;
        this.fontAdapter = builder.fontAdapter;
        this.imageLoaderAdapter = builder.imageLoaderAdapter;
        this.storageAdapter = builder.storageAdapter;
        this.navAdapter = builder.navAdapter;
        this.scriptLoaderAdapter = builder.scriptLoaderAdapter;
        this.trackerAdapter = builder.trackerAdapter;
        this.componentInvokerIndexes = builder.componentInvokerIndexes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public JSLogger.Logger getJsLogger() {
        if (this.jsLogger == null) {
            this.jsLogger = (level, msg) -> {};
        }
        return this.jsLogger;
    }

    public EventTracer.Trace getEventTracer() {
        if (this.eventTracer == null) {
            this.eventTracer = (event, params) -> {};
        }
        return this.eventTracer;
    }

    public ExceptionCallback getExceptionCallback() {
        if (this.exceptionCallback == null) {
            this.exceptionCallback = e -> {};
        }
        return this.exceptionCallback;
    }

    public boolean isSupportRTL() {
        return this.isSupportRTL;
    }

    public boolean isSupportBytecode() {
        return this.isSupportBytecode;
    }

    @Deprecated
    public String getFontsAssetsPath() {
        return this.fontsAssetsPath;
    }

    public IHttpAdapter getHttpAdapter() {
        if (this.httpAdapter == null) {
            this.httpAdapter = new DefaultHttpAdapter();
        }
        return this.httpAdapter;
    }

    public IFontAdapter getFontAdapter() {
        if (this.fontAdapter == null) {
            this.fontAdapter = new DefaultFontAdapter(this.fontsAssetsPath);
        }
        return this.fontAdapter;
    }

    public IImageLoaderAdapter getImageLoaderAdapter() {
        if (this.imageLoaderAdapter == null) {
            this.imageLoaderAdapter = new DefaultImageLoaderAdapter();
        }
        return this.imageLoaderAdapter;
    }

    public IStorageAdapter getStorageAdapter() {
        if (this.storageAdapter == null) {
            this.storageAdapter = new DefaultStorageAdapter();
        }
        this.storageAdapter.setNamespace(this.namespace);
        return this.storageAdapter;
    }

    public INavigatorAdapter getNavAdapter() {
        if (this.navAdapter == null) {
            this.navAdapter = new DefaultNavigatorAdapter();
        }
        return this.navAdapter;
    }

    public IScriptLoaderAdapter getScriptLoaderAdapter() {
        if (this.scriptLoaderAdapter == null) {
            this.scriptLoaderAdapter = new DefaultScriptLoaderAdapter();
        }
        return this.scriptLoaderAdapter;
    }

    public ITrackerAdapter getTrackerAdapter() {
        if (this.trackerAdapter == null) {
            this.trackerAdapter = new EmptyTrackerAdapter();
        }
        return this.trackerAdapter;
    }

    public List<ComponentInvokerIndex> getComponentInvokerIndexes() {
        return this.componentInvokerIndexes;
    }

    public static class Builder {
        private String namespace = "_HUMMER_SDK_NAMESPACE_DEFAULT_";
        private JSLogger.Logger jsLogger;
        private EventTracer.Trace eventTracer;
        private ExceptionCallback exceptionCallback;
        private boolean isSupportRTL;
        private boolean isSupportBytecode;
        private String fontsAssetsPath;
        private IHttpAdapter httpAdapter;
        private IFontAdapter fontAdapter;
        private IImageLoaderAdapter imageLoaderAdapter;
        private IStorageAdapter storageAdapter;
        private INavigatorAdapter navAdapter;
        private IScriptLoaderAdapter scriptLoaderAdapter;
        private ITrackerAdapter trackerAdapter;
        private List<ComponentInvokerIndex> componentInvokerIndexes;

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setJSLogger(JSLogger.Logger logger) {
            this.jsLogger = logger;
            return this;
        }

        @Deprecated
        public Builder setEventTracer(EventTracer.Trace trace) {
            this.eventTracer = trace;
            return this;
        }

        public Builder setExceptionCallback(ExceptionCallback callback) {
            this.exceptionCallback = callback;
            return this;
        }

        public Builder setSupportRTL(boolean supportRTL) {
            this.isSupportRTL = supportRTL;
            return this;
        }

        public Builder setSupportBytecode(boolean supportBytecode) {
            this.isSupportBytecode = supportBytecode;
            return this;
        }

        @Deprecated
        public Builder setFontsAssetsPath(String fontsAssetsPath) {
            this.fontsAssetsPath = fontsAssetsPath;
            return this;
        }

        public Builder setHttpAdapter(IHttpAdapter adapter) {
            this.httpAdapter = adapter;
            return this;
        }

        public Builder setFontAdapter(IFontAdapter adapter) {
            this.fontAdapter = adapter;
            return this;
        }

        public Builder setImageLoaderAdapter(IImageLoaderAdapter adapter) {
            this.imageLoaderAdapter = adapter;
            return this;
        }

        public Builder setStorageAdapter(IStorageAdapter adapter) {
            this.storageAdapter = adapter;
            return this;
        }

        public Builder setNavigatorAdapter(INavigatorAdapter adapter) {
            this.navAdapter = adapter;
            return this;
        }

        public Builder setScriptLoaderAdapter(IScriptLoaderAdapter adapter) {
            this.scriptLoaderAdapter = adapter;
            return this;
        }

        public Builder setTrackerAdapter(ITrackerAdapter adapter) {
            this.trackerAdapter = adapter;
            return this;
        }

        public Builder addIndex(ComponentInvokerIndex index) {
            if (this.componentInvokerIndexes == null) {
                this.componentInvokerIndexes = new ArrayList<ComponentInvokerIndex>();
            }
            this.componentInvokerIndexes.add(index);
            return this;
        }

        public HummerConfig builder() {
            return new HummerConfig(this);
        }
    }
}

