/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.didi.hummer.HummerConfig;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.navigator.impl.ActivityStackManager;
import com.didi.hummer.adapter.tracker.ITrackerAdapter;
import com.didi.hummer.adapter.tracker.SDKInfo;
import com.didi.hummer.core.engine.jsc.jni.HummerException;
import com.didi.hummer.core.engine.napi.jni.JSException;
import com.didi.hummer.core.exception.ExceptionCallback;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.debug.plugin.IHermesDebugger;
import com.didi.hummer.debug.plugin.IV8Debugger;
import com.didi.hummer.tools.EventTracer;
import com.didi.hummer.tools.JSLogger;
import com.didi.hummer.utils.EnvUtil;
import com.didi.hummer.utils.blankj.Utils;
import com.facebook.soloader.SoLoader;
import com.getkeepsafe.relinker.ReLinker;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class HummerSDK {
    public static final String NAMESPACE_DEFAULT = "_HUMMER_SDK_NAMESPACE_DEFAULT_";
    public static Context appContext;
    private static int jsEngine;
    private static volatile boolean isInited;
    private static Map<String, HummerConfig> configs;
    private static IV8Debugger v8Debugger;
    private static IHermesDebugger hermesDebugger;
    private static SDKInfo sdkInfo;
    private static volatile boolean isSdkInfoTracked;

    public static boolean isSupport(Context context, int engine) {
        return HummerSDK.loadJSEngine(context, engine);
    }

    public static void setJsEngine(int jsEngine) {
        HummerSDK.jsEngine = jsEngine;
    }

    public static int getJsEngine() {
        return jsEngine;
    }

    public static void init(Context context) {
        HummerSDK.init(context, null);
    }

    public static void init(Context context, HummerConfig config) {
        long startTime = System.currentTimeMillis();
        if (!isInited) {
            appContext = context.getApplicationContext();
            HummerSDK.parseAppDebuggable(appContext);
            Utils.init((Application)appContext);
            ActivityStackManager.getInstance().register((Application)appContext);
            HummerSDK.loadYogaEngine();
            HummerSDK.loadJSEngine(appContext, jsEngine);
            if (jsEngine == 5 || jsEngine == 6) {
                JSException.init();
            } else {
                HummerException.init();
            }
            EnvUtil.initHummerEnv(appContext);
            isInited = true;
            HummerSDK.sdkInfo.jsEngine = jsEngine;
            HummerSDK.sdkInfo.isSdkInitSuccess = true;
            HummerSDK.sdkInfo.sdkInitTimeCost = System.currentTimeMillis() - startTime;
        }
        HummerSDK.addHummerConfig(config);
        String namespace = config != null ? config.getNamespace() : null;
        ITrackerAdapter trackerAdapter = HummerAdapter.getTrackerAdapter(namespace);
        if (!isSdkInfoTracked && trackerAdapter != null) {
            trackerAdapter.trackSDKInfo(sdkInfo);
            trackerAdapter.trackEvent("tech_hummer_sdk_init", null);
            isSdkInfoTracked = true;
        }
    }

    public static void release() {
        ActivityStackManager.getInstance().unRegister((Application)appContext);
        configs.clear();
        isInited = false;
    }

    public static void initV8Debugger(IV8Debugger debugger) {
        if (v8Debugger == null) {
            v8Debugger = debugger;
        }
    }

    public static IV8Debugger getV8Debugger() {
        return v8Debugger;
    }

    public static void initHermesDebugger(IHermesDebugger debugger) {
        HummerSDK.initHermesDebugger(debugger, 6);
    }

    public static void initHermesDebugger(IHermesDebugger debugger, int jsEngine) {
        if (hermesDebugger == null) {
            HummerSDK.setJsEngine(jsEngine);
            hermesDebugger = debugger;
        }
    }

    public static IHermesDebugger getHermesDebugger() {
        return hermesDebugger;
    }

    private static void addHummerConfig(HummerConfig config) {
        if (config != null) {
            String namespace = config.getNamespace();
            HummerConfig c = configs.get(namespace);
            if (c == null || TextUtils.isEmpty((CharSequence)c.getNamespace())) {
                configs.put(namespace, config);
            } else if (DebugUtil.isDebuggable()) {
                Toast.makeText((Context)appContext, (CharSequence)("There is already a duplicate namespace: " + namespace), (int)0).show();
            }
        }
        if (!configs.containsKey(NAMESPACE_DEFAULT)) {
            configs.put(NAMESPACE_DEFAULT, new HummerConfig.Builder().setNamespace(null).builder());
        }
    }

    public static HummerConfig getHummerConfig(String namespace) {
        if (TextUtils.isEmpty((CharSequence)namespace) || !configs.containsKey(namespace)) {
            namespace = NAMESPACE_DEFAULT;
        }
        if (!configs.containsKey(NAMESPACE_DEFAULT)) {
            configs.put(NAMESPACE_DEFAULT, new HummerConfig.Builder().setNamespace(null).builder());
        }
        return configs.get(namespace);
    }

    private static void loadYogaEngine() {
        try {
            SoLoader.init((Context)appContext, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean loadJSEngine(Context context, int engine) {
        try {
            switch (engine) {
                case 1: {
                    ReLinker.loadLibrary((Context)context, (String)"hummer-jsc");
                    break;
                }
                case 4: {
                    ReLinker.loadLibrary((Context)context, (String)"hummer-hermes");
                    break;
                }
                case 5: 
                case 6: {
                    if (HummerSDK.getHermesDebugger() != null) {
                        ReLinker.loadLibrary((Context)context, (String)"hummer-napi-debugger");
                        break;
                    }
                    ReLinker.loadLibrary((Context)context, (String)"hummer-napi");
                    break;
                }
                default: {
                    ReLinker.loadLibrary((Context)context, (String)"hummer-qjs");
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void parseAppDebuggable(Context context) {
        try {
            boolean isAppDebuggable = context.getApplicationInfo() != null && (context.getApplicationInfo().flags & 2) != 0;
            DebugUtil.setDebuggable((boolean)isAppDebuggable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSLogger.Logger getJSLogger(String namespace) {
        return HummerSDK.getHummerConfig(namespace).getJsLogger();
    }

    public static EventTracer.Trace getEventTracer(String namespace) {
        return HummerSDK.getHummerConfig(namespace).getEventTracer();
    }

    public static ExceptionCallback getException(String namespace) {
        return HummerSDK.getHummerConfig(namespace).getExceptionCallback();
    }

    public static boolean isSupportRTL(String namespace) {
        return HummerSDK.getHummerConfig(namespace).isSupportRTL();
    }

    public static boolean isSupportBytecode(String namespace) {
        return HummerSDK.getHummerConfig(namespace).isSupportBytecode();
    }

    public static String getFontsAssetsPath(String namespace) {
        return HummerSDK.getHummerConfig(namespace).getFontsAssetsPath();
    }

    static {
        jsEngine = 5;
        configs = new HashMap<String, HummerConfig>();
        sdkInfo = new SDKInfo();
        isSdkInfoTracked = false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JsEngine {
        public static final int JSC = 1;
        public static final int QUICK_JS = 2;
        public static final int V8 = 3;
        public static final int HERMES = 4;
        public static final int NAPI_QJS = 5;
        public static final int NAPI_HERMES = 6;
    }
}

