/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.font.impl;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.didi.hummer.adapter.font.IFontAdapter;
import com.didi.hummer.core.util.HMLog;

public class DefaultFontAdapter
implements IFontAdapter {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    private final String fontsAssetsPath;

    public DefaultFontAdapter(String fontsAssetsPath) {
        if (TextUtils.isEmpty((CharSequence)fontsAssetsPath)) {
            this.fontsAssetsPath = FONTS_ASSET_PATH;
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)fontsAssetsPath) && !fontsAssetsPath.endsWith("/")) {
            fontsAssetsPath = fontsAssetsPath + "/";
        }
        this.fontsAssetsPath = fontsAssetsPath;
    }

    @Override
    public Typeface loadFont(@NonNull Context context, @Nullable String fontFamily, int style) {
        if (TextUtils.isEmpty((CharSequence)fontFamily)) {
            return null;
        }
        String extension = EXTENSIONS[style];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = this.fontsAssetsPath + fontFamily + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fileName);
            }
            catch (Exception e) {
                HMLog.w((String)"HummerNative", (String)e.getMessage());
            }
        }
        return null;
    }
}

