/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.http.impl;

import android.text.TextUtils;
import com.didi.hummer.adapter.http.HttpCallback;
import com.didi.hummer.adapter.http.HttpResponse;
import com.didi.hummer.adapter.http.IHttpAdapter;
import com.didi.hummer.adapter.http.impl.FakeX509TrustManager;
import com.didi.hummer.core.util.HMGsonUtil;
import com.didi.hummer.utils.UIThreadUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DefaultHttpAdapter
implements IHttpAdapter {
    public static final MediaType MEDIA_TYPE_NORMAL_FORM = MediaType.parse((String)"application/x-www-form-urlencoded;charset=utf-8");
    public static final MediaType MEDIA_TYPE_MULTIPART_FORM = MediaType.parse((String)"multipart/form-data;charset=utf-8");
    public static final MediaType MEDIA_TYPE_STREAM = MediaType.parse((String)"application/octet-stream");
    public static final MediaType MEDIA_TYPE_TEXT = MediaType.parse((String)"text/plain;charset=utf-8");
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json;charset=utf-8");
    public static final String CONTENT_TYPE = "content-type";
    private OkHttpClient httpClient = new OkHttpClient.Builder().sslSocketFactory(FakeX509TrustManager.allowAllSSL(), (X509TrustManager)new FakeX509TrustManager()).build();

    @Override
    public String onUrlIntercept(String orgUrl) {
        return null;
    }

    @Override
    public <T> void request(String url, String method, int timeout, Map<String, Object> headers, Map<String, Object> param, HttpCallback<T> callback, Type type) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)method)) {
            return;
        }
        switch (method = method.toUpperCase()) {
            case "GET": {
                this.get(url, timeout, headers, param, callback, type);
                break;
            }
            case "POST": {
                this.post(url, timeout, headers, param, callback, type);
                break;
            }
        }
    }

    private <T> void get(String url, int timeout, Map<String, Object> headers, Map<String, Object> params, final HttpCallback<T> callback, final Type type) {
        url = this.buildUrlWithParams(url, params);
        OkHttpClient client = this.httpClient.newBuilder().connectTimeout((long)timeout, TimeUnit.MILLISECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
        Request.Builder builder = new Request.Builder().url(url);
        this.addHeaders(builder, headers);
        Request request = builder.build();
        client.newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                HttpResponse resp = DefaultHttpAdapter.this.processResponse(response, type);
                UIThreadUtil.runOnUiThread(() -> {
                    if (callback != null) {
                        callback.onResult(resp);
                    }
                });
            }

            public void onFailure(Call call, IOException e) {
                UIThreadUtil.runOnUiThread(() -> {
                    if (callback != null) {
                        callback.onResult(DefaultHttpAdapter.this.processError(e));
                    }
                });
            }
        });
    }

    private <T> void post(String url, int timeout, Map<String, Object> headers, Map<String, Object> params, final HttpCallback<T> callback, final Type type) {
        OkHttpClient client = this.httpClient.newBuilder().connectTimeout((long)timeout, TimeUnit.MILLISECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
        Request.Builder builder = new Request.Builder().url(url);
        this.addHeaders(builder, headers);
        RequestBody body = this.createBody(headers, params);
        Request request = builder.post(body).build();
        client.newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                HttpResponse resp = DefaultHttpAdapter.this.processResponse(response, type);
                UIThreadUtil.runOnUiThread(() -> {
                    if (callback != null) {
                        callback.onResult(resp);
                    }
                });
            }

            public void onFailure(Call call, IOException e) {
                UIThreadUtil.runOnUiThread(() -> {
                    if (callback != null) {
                        callback.onResult(DefaultHttpAdapter.this.processError(e));
                    }
                });
            }
        });
    }

    private String buildUrlWithParams(String url, Map<String, Object> params) {
        StringBuilder strUrl = new StringBuilder(url);
        String strParams = this.encodeEachParam(params);
        if (!TextUtils.isEmpty((CharSequence)strParams)) {
            if (url.contains("?")) {
                strUrl.append("&");
            } else {
                strUrl.append("?");
            }
            strUrl.append(strParams);
        }
        return strUrl.toString();
    }

    private void addHeaders(Request.Builder builder, Map<String, Object> headers) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = String.valueOf(headers.get(key));
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                builder.addHeader(key, value);
            }
        }
    }

    private RequestBody createBody(Map<String, Object> headers, Map<String, Object> params) {
        MediaType mediaType = this.getMediaTypeFromHeaders(headers);
        RequestBody body = String.valueOf(mediaType).contains("text/plain") ? this.createTextRequestBody(mediaType, params) : (String.valueOf(mediaType).contains("application/x-www-form-urlencoded") ? this.createFormRequestBody(params) : this.createJsonRequestBody(mediaType, params));
        return body;
    }

    private RequestBody createJsonRequestBody(MediaType mediaType, Map<String, Object> params) {
        return RequestBody.create((MediaType)mediaType, (String)this.getWholeParamsString(params));
    }

    private RequestBody createTextRequestBody(MediaType mediaType, Map<String, Object> params) {
        return RequestBody.create((MediaType)mediaType, (String)this.encodeWholeParamsString(params));
    }

    private RequestBody createFormRequestBody(Map<String, Object> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                builder.add(key, String.valueOf(params.get(key)));
            }
        }
        return builder.build();
    }

    private MediaType getMediaTypeFromHeaders(Map<String, Object> headers) {
        if (headers == null) {
            return MEDIA_TYPE_JSON;
        }
        String contentType = null;
        for (String key : headers.keySet()) {
            if (key == null || !key.toLowerCase().equals(CONTENT_TYPE) || headers.get(key) == null) continue;
            contentType = String.valueOf(headers.get(key));
            break;
        }
        if (TextUtils.isEmpty(contentType)) {
            return MEDIA_TYPE_JSON;
        }
        return MediaType.parse(contentType);
    }

    private String encodeEachParam(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            String value = String.valueOf(params.get(key));
            try {
                key = URLEncoder.encode(key, "UTF-8");
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result.append(key).append("=").append(value);
        }
        return result.toString();
    }

    private String getWholeParamsString(Map<String, Object> params) {
        String paramStr = HMGsonUtil.toJson(params);
        if (paramStr == null) {
            paramStr = "";
        }
        return paramStr;
    }

    private String encodeWholeParamsString(Map<String, Object> params) {
        String paramStr = HMGsonUtil.toJson(params);
        if (paramStr == null) {
            paramStr = "";
        }
        try {
            paramStr = URLEncoder.encode(paramStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return paramStr;
    }

    private HttpResponse processResponse(Response response, Type type) throws IOException {
        HttpResponse resp = new HttpResponse();
        Headers headers = response.headers();
        if (headers != null && headers.size() > 0) {
            resp.header = new HashMap<String, String>();
            for (String key : headers.names()) {
                resp.header.put(key, headers.get(key));
            }
        }
        resp.status = response.code();
        resp.message = response.message();
        resp.data = this.parseResponseBody(response.body(), type);
        if (!response.isSuccessful()) {
            resp.error = new HttpResponse.Error(resp.status, resp.message);
            return resp;
        }
        return resp;
    }

    private Object parseResponseBody(ResponseBody body, Type type) throws IOException {
        if (body == null) {
            return null;
        }
        String respStr = body.string();
        if (HMGsonUtil.isValidJsonString((String)respStr) && type != null) {
            return HMGsonUtil.fromJson((String)respStr, (Type)type);
        }
        return respStr;
    }

    private HttpResponse processError(Exception e) {
        HttpResponse resp = new HttpResponse();
        resp.message = e.toString();
        resp.error = new HttpResponse.Error(-102, e.toString());
        return resp;
    }
}

