/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.imageloader.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.adapter.imageloader.DrawableCallback;
import com.didi.hummer.adapter.imageloader.IImageLoaderAdapter;
import com.didi.hummer.adapter.imageloader.ImageSizeCallback;
import com.didi.hummer.core.engine.JSCallback;

public class DefaultImageLoaderAdapter
implements IImageLoaderAdapter {
    private static final int FAIL_SRC = 0;
    private static final int REMOTE_SRC = 1;
    private static final int LOCAL_SRC = 2;

    @Override
    public void setImage(String url, ImageView view) {
        this.setImage(url, null, null, view);
    }

    @Override
    public void setImage(String url, Drawable placeholder, Drawable failedImage, ImageView view) {
        this.setImage(url, placeholder, failedImage, view, null);
    }

    @Override
    public void setImage(String url, ImageView view, JSCallback completeCallback) {
        this.setImage(url, null, null, view, completeCallback);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void setImage(String url, Drawable placeholder, Drawable failedImage, ImageView view, final JSCallback completeCallback) {
        try {
            RequestOptions requestOptions = new RequestOptions();
            if (view.getScaleType() == ImageView.ScaleType.CENTER) {
                requestOptions.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            if (placeholder != null) {
                requestOptions.placeholder(placeholder);
            }
            if (failedImage != null) {
                requestOptions.error(failedImage);
            }
            if (completeCallback != null) {
                Glide.with((Context)view.getContext()).load(url).apply((BaseRequestOptions)requestOptions).listener((RequestListener)new RequestListener<Drawable>(){

                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        completeCallback.call(new Object[]{0, false});
                        return false;
                    }

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        if (dataSource.equals((Object)DataSource.REMOTE)) {
                            completeCallback.call(new Object[]{1, true});
                        } else {
                            completeCallback.call(new Object[]{2, true});
                        }
                        return false;
                    }
                }).into(view);
            } else {
                Glide.with((Context)view.getContext()).load(url).apply((BaseRequestOptions)requestOptions).into(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setGif(String url, int repeatCount, ImageView view) {
        this.setGif(url, null, null, repeatCount, view);
    }

    @Override
    public void setGif(String url, int repeatCount, ImageView view, JSCallback completeCallback) {
        this.setGif(url, null, null, repeatCount, view, completeCallback);
    }

    @Override
    public void setGif(String url, Drawable placeholder, Drawable failedImage, int repeatCount, ImageView view) {
        this.setGif(url, placeholder, failedImage, repeatCount, view, null);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void setGif(String url, Drawable placeholder, Drawable failedImage, int repeatCount, ImageView view, final JSCallback completeCallback) {
        final int fRepeatCount = repeatCount == 0 ? -1 : repeatCount;
        try {
            RequestOptions requestOptions = new RequestOptions();
            if (view.getScaleType() == ImageView.ScaleType.CENTER) {
                requestOptions.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            if (placeholder != null) {
                requestOptions.placeholder(placeholder);
            }
            if (failedImage != null) {
                requestOptions.error(failedImage);
            }
            Glide.with((Context)view.getContext()).asGif().load(url).listener((RequestListener)new RequestListener<GifDrawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                    if (completeCallback != null) {
                        completeCallback.call(new Object[]{0, false});
                    }
                    return false;
                }

                public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                    resource.setLoopCount(fRepeatCount);
                    if (completeCallback != null) {
                        if (dataSource.equals((Object)DataSource.REMOTE)) {
                            completeCallback.call(new Object[]{1, true});
                        } else {
                            completeCallback.call(new Object[]{2, true});
                        }
                    }
                    return false;
                }
            }).into(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setImage(int resId, ImageView view) {
        this.setImage(resId, view, null);
    }

    @Override
    public void setImage(int resId, ImageView view, JSCallback completeCallback) {
        if (view != null) {
            view.setImageResource(resId);
            if (completeCallback != null) {
                completeCallback.call(new Object[]{2, true});
            }
        } else if (completeCallback != null) {
            completeCallback.call(new Object[]{0, false});
        }
    }

    @Override
    public void setGif(int resId, int repeatCount, ImageView view) {
        this.setGif(resId, repeatCount, view, null);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void setGif(int resId, int repeatCount, ImageView view, final JSCallback completeCallback) {
        final int fRepeatCount = repeatCount == 0 ? -1 : repeatCount;
        try {
            RequestOptions requestOptions = new RequestOptions();
            if (view.getScaleType() == ImageView.ScaleType.CENTER) {
                requestOptions.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            Glide.with((Context)view.getContext()).asGif().load(Integer.valueOf(resId)).listener((RequestListener)new RequestListener<GifDrawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                    if (completeCallback != null) {
                        completeCallback.call(new Object[]{0, false});
                    }
                    return false;
                }

                public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                    resource.setLoopCount(fRepeatCount);
                    if (completeCallback != null) {
                        if (dataSource.equals((Object)DataSource.REMOTE)) {
                            completeCallback.call(new Object[]{1, true});
                        } else {
                            completeCallback.call(new Object[]{2, true});
                        }
                    }
                    return false;
                }
            }).into(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadDrawable(String url, final DrawableCallback callback) {
        block2: {
            try {
                Glide.with((Context)HummerSDK.appContext).load(url).into((Target)new CustomTarget<Drawable>(){

                    public void onLoadCleared(@Nullable Drawable placeholder) {
                    }

                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        if (callback != null) {
                            callback.onDrawableLoaded(resource);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block2;
                callback.onDrawableLoaded(null);
            }
        }
    }

    @Override
    public void loadDrawable(int resId, DrawableCallback callback) {
        Drawable drawable = HummerSDK.appContext.getResources().getDrawable(resId);
        if (callback != null) {
            callback.onDrawableLoaded(drawable);
        }
    }

    @Override
    public void getImageSize(String url, final ImageSizeCallback callback) {
        block2: {
            try {
                Glide.with((Context)HummerSDK.appContext).load(url).into((Target)new CustomTarget<Drawable>(){

                    public void onLoadCleared(@Nullable Drawable placeholder) {
                    }

                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        if (callback != null) {
                            callback.onSizeReady(resource.getIntrinsicWidth(), resource.getIntrinsicHeight());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block2;
                callback.onSizeReady(0, 0);
            }
        }
    }

    @Override
    public void getImageSize(int resId, final ImageSizeCallback callback) {
        block2: {
            try {
                Glide.with((Context)HummerSDK.appContext).load(Integer.valueOf(resId)).into((Target)new CustomTarget<Drawable>(){

                    public void onLoadCleared(@Nullable Drawable placeholder) {
                    }

                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        if (callback != null) {
                            callback.onSizeReady(resource.getIntrinsicWidth(), resource.getIntrinsicHeight());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callback == null) break block2;
                callback.onSizeReady(0, 0);
            }
        }
    }
}

