/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.navigator;

import android.net.Uri;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.Map;

public class NavPage
implements Serializable {
    public String id;
    public String url;
    public String sourcePath;
    public boolean animated = true;
    public boolean closeSelf;
    public Map<String, Object> params;

    public NavPage() {
    }

    public NavPage(String url) {
        this.url = url;
    }

    public NavPage(String id, String url) {
        this.id = id;
        this.url = url;
    }

    public String toString() {
        return "NavPage{id='" + this.id + '\'' + ", url='" + this.url + '\'' + ", sourcePath='" + this.sourcePath + '\'' + ", animated=" + this.animated + ", closeSelf=" + this.closeSelf + ", params=" + this.params + '}';
    }

    public boolean isJsUrl() {
        return this.url != null && this.url.toLowerCase().endsWith(".js");
    }

    public boolean isHttpUrl() {
        return this.url != null && this.url.toLowerCase().startsWith("http");
    }

    public String getScheme() {
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            return null;
        }
        Uri uri = Uri.parse((String)this.url);
        return uri.getScheme();
    }

    public String getHost() {
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            return null;
        }
        Uri uri = Uri.parse((String)this.url);
        return uri.getHost();
    }

    public String getPath() {
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            return null;
        }
        Uri uri = Uri.parse((String)this.url);
        return uri.getPath();
    }

    public String getPageName() {
        return this.getHost() + this.getPath();
    }
}

