/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.navigator.impl;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.core.util.HMLog;
import java.util.Stack;

public class ActivityStackManager
implements Application.ActivityLifecycleCallbacks {
    private Stack<Activity> stack = new Stack();

    private ActivityStackManager() {
    }

    public static ActivityStackManager getInstance() {
        return Instance.INSTANCE;
    }

    public void register(Application app) {
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void unRegister(Application app) {
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    private void addActivity(Activity activity) {
        this.stack.push(activity);
    }

    private void removeActivity(Activity activity) {
        if (!this.stack.isEmpty()) {
            this.stack.remove(activity);
        }
    }

    public Activity getTopActivity() {
        if (!this.stack.isEmpty()) {
            return this.stack.peek();
        }
        return null;
    }

    public void finishTopActivity() {
        if (this.stack.size() > 0) {
            this.stack.peek().finish();
        }
    }

    public void finishActivity(String pageId) {
        Activity activity = this.getActivity(pageId);
        if (activity != null) {
            activity.finish();
        }
    }

    public Activity getActivity(String pageId) {
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)this.stack.get(i);
            String activityPageId = this.getPageIdFromActivity(activity);
            if (!pageId.equals(activityPageId)) continue;
            return activity;
        }
        return null;
    }

    public void popToActivity(String pageId, boolean animated) {
        Activity activity;
        int i;
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            return;
        }
        int count = 0;
        boolean matched = false;
        for (i = this.stack.size() - 1; i >= 0; --i) {
            activity = (Activity)this.stack.get(i);
            String activityPageId = this.getPageIdFromActivity(activity);
            if (pageId.equals(activityPageId)) {
                matched = true;
                break;
            }
            ++count;
        }
        if (matched) {
            for (i = 0; i < count; ++i) {
                if (this.stack.isEmpty()) continue;
                activity = this.stack.pop();
                if (activity != null) {
                    activity.finish();
                }
                if (animated || activity == null) continue;
                activity.overridePendingTransition(0, 0);
            }
        }
    }

    public void popToRootActivity(boolean animated) {
        while (this.stack.size() > 1) {
            Activity activity = this.stack.pop();
            if (activity != null) {
                activity.finish();
            }
            if (animated || activity == null) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public void popBack(int count, boolean animated) {
        if (count < 1) {
            count = 1;
        }
        if (count > this.stack.size()) {
            count = this.stack.size();
        }
        for (int i = 0; i < count; ++i) {
            Activity activity = this.stack.pop();
            if (activity != null) {
                activity.finish();
            }
            if (animated || activity == null) continue;
            activity.overridePendingTransition(0, 0);
        }
    }

    public void finishAllActivity() {
        while (!this.stack.empty()) {
            this.stack.pop().finish();
        }
    }

    private String getPageIdFromActivity(Activity activity) {
        if (activity == null) {
            return null;
        }
        String pageId = null;
        if (activity.getIntent() != null) {
            try {
                pageId = activity.getIntent().getStringExtra("PAGE_ID");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pageId == null) {
            pageId = activity.toString();
        }
        return pageId;
    }

    private void printActivityStack(Stack<Activity> stack) {
        HMLog.d((String)"HummerNative", (String)"----------- stack start -----------");
        for (int i = stack.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)stack.get(i);
            String activityPageId = this.getPageIdFromActivity(activity);
            HMLog.d((String)"HummerNative", (String)("|\t" + activity + " -> " + activityPageId));
        }
        HMLog.d((String)"HummerNative", (String)"----------- stack end -----------");
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.addActivity(activity);
        if (DebugUtil.isDebuggable()) {
            this.printActivityStack(this.stack);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.removeActivity(activity);
        if (DebugUtil.isDebuggable()) {
            this.printActivityStack(this.stack);
        }
    }

    private static class Instance {
        public static ActivityStackManager INSTANCE = new ActivityStackManager();

        private Instance() {
        }
    }
}

