/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.navigator.impl;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.adapter.navigator.INavigatorAdapter;
import com.didi.hummer.adapter.navigator.NavCallback;
import com.didi.hummer.adapter.navigator.NavPage;
import com.didi.hummer.adapter.navigator.impl.ActivityStackManager;
import com.didi.hummer.adapter.navigator.impl.DefaultIntentCreator;
import com.didi.hummer.adapter.navigator.impl.IntentCreator;
import com.didi.hummer.adapter.navigator.impl.router.ActivityLauncher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultNavigatorAdapter
implements INavigatorAdapter {
    public static final String EXTRA_PAGE_ID = "PAGE_ID";
    public static final String EXTRA_PAGE_MODEL = "PAGE_MODEL";
    public static final String SCHEME_HUMMER = "hummer";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    protected IntentCreator intentCreator;

    public DefaultNavigatorAdapter() {
        this(null);
    }

    public DefaultNavigatorAdapter(IntentCreator intentCreator) {
        this.intentCreator = intentCreator;
        if (this.intentCreator == null) {
            this.intentCreator = new DefaultIntentCreator();
        }
    }

    @Override
    public void openPage(Context context, NavPage page, NavCallback callback) {
        if (context == null) {
            context = HummerSDK.appContext;
        }
        this.goToPage(context, page, callback);
    }

    @Override
    public void popPage(Context context, NavPage page) {
        Activity popActivity = null;
        if (page != null && !TextUtils.isEmpty((CharSequence)page.id)) {
            popActivity = ActivityStackManager.getInstance().getActivity(page.id);
        } else if (context instanceof Activity) {
            popActivity = (Activity)context;
        }
        if (popActivity == null) {
            return;
        }
        popActivity.finish();
        if (page != null && !page.animated) {
            popActivity.overridePendingTransition(0, 0);
        }
    }

    @Override
    public void popToPage(Context context, NavPage page) {
        if (page == null) {
            return;
        }
        ActivityStackManager.getInstance().popToActivity(page.id, page.animated);
    }

    @Override
    public void popToRootPage(Context context, NavPage page) {
        boolean animated = page == null || page.animated;
        ActivityStackManager.getInstance().popToRootActivity(animated);
    }

    @Override
    public void popBack(Context context, int count, NavPage page) {
        if (count == 1) {
            this.popPage(context, page);
        } else {
            boolean animated = page == null || page.animated;
            ActivityStackManager.getInstance().popBack(count, animated);
        }
    }

    protected void goToPage(Context context, NavPage page, NavCallback callback) {
        if (context == null || page == null || TextUtils.isEmpty((CharSequence)page.url)) {
            return;
        }
        String scheme = page.getScheme();
        if (!TextUtils.isEmpty((CharSequence)scheme)) {
            switch (scheme = scheme.toLowerCase()) {
                case "hummer": {
                    this.openHummerPage(context, page, callback);
                    break;
                }
                case "http": 
                case "https": {
                    if (page.isJsUrl()) {
                        this.openHummerPage(context, page, callback);
                        break;
                    }
                    this.openWebPage(context, page, callback);
                    break;
                }
                default: {
                    if (page.isJsUrl()) {
                        this.openHummerPage(context, page, callback);
                        break;
                    }
                    this.openCustomPage(context, page, callback);
                    break;
                }
            }
        } else if (page.isJsUrl()) {
            this.openHummerPage(context, page, callback);
        }
    }

    protected void openHummerPage(Context context, NavPage page, NavCallback callback) {
        Intent intent = this.intentCreator.createHummerIntent(context, page);
        this.openPage(context, intent, page, callback);
    }

    protected void openWebPage(Context context, NavPage page, NavCallback callback) {
        Intent intent = this.intentCreator.createWebIntent(context, page);
        this.openPage(context, intent, page, callback);
    }

    protected void openCustomPage(Context context, NavPage page, NavCallback callback) {
        Intent intent = this.intentCreator.createCustomIntent(context, page);
        this.openPage(context, intent, page, callback);
    }

    protected void openPage(Context context, Intent intent, NavPage page, NavCallback callback) {
        if (intent == null) {
            return;
        }
        if (context instanceof Application) {
            intent.addFlags(0x10000000);
        }
        if (page.closeSelf) {
            context.startActivity(intent);
        } else {
            ActivityLauncher.init(context).startActivityForResult(intent, (resultCode, data) -> {
                Map<String, Object> result = this.transIntentData(data);
                if (callback != null && result != null) {
                    callback.onResult(result);
                }
            });
        }
        if (!page.animated && context instanceof Activity) {
            ((Activity)context).overridePendingTransition(0, 0);
        }
        if (page.closeSelf && context instanceof Activity) {
            ((Activity)context).finish();
        }
    }

    protected Map<String, Object> transIntentData(Intent intent) {
        HashMap<String, Object> data = null;
        try {
            if (intent != null && intent.getExtras() != null) {
                Bundle bundle = intent.getExtras();
                data = new HashMap<String, Object>();
                Set keys = bundle.keySet();
                for (String key : keys) {
                    Object value = bundle.get(key);
                    if (value == null) continue;
                    data.put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

