/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.navigator.impl.router;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.didi.hummer.adapter.navigator.impl.router.RouterFragment;
import com.didi.hummer.adapter.navigator.impl.router.RouterFragmentV4;

public class ActivityLauncher {
    private static final String TAG = "ActivityLauncher";
    private Context mContext;
    private RouterFragmentV4 mRouterFragmentV4;
    private RouterFragment mRouterFragment;

    public static ActivityLauncher init(Context context) {
        return new ActivityLauncher(context);
    }

    public static ActivityLauncher init(android.support.v4.app.Fragment fragment) {
        return ActivityLauncher.init((Context)fragment.getActivity());
    }

    private ActivityLauncher(Context context) {
        this.mContext = context;
        if (context instanceof FragmentActivity) {
            this.mRouterFragmentV4 = this.getRouterFragmentV4((FragmentActivity)context);
        } else if (context instanceof Activity) {
            this.mRouterFragment = this.getRouterFragment((Activity)context);
        }
    }

    private RouterFragmentV4 getRouterFragmentV4(FragmentActivity activity) {
        RouterFragmentV4 routerFragment = this.findRouterFragmentV4(activity);
        if (routerFragment == null) {
            routerFragment = RouterFragmentV4.newInstance();
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            fragmentManager.beginTransaction().add((android.support.v4.app.Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private RouterFragmentV4 findRouterFragmentV4(FragmentActivity activity) {
        return (RouterFragmentV4)activity.getSupportFragmentManager().findFragmentByTag(TAG);
    }

    private RouterFragment getRouterFragment(Activity activity) {
        RouterFragment routerFragment = this.findRouterFragment(activity);
        if (routerFragment == null) {
            routerFragment = RouterFragment.newInstance();
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private RouterFragment findRouterFragment(Activity activity) {
        return (RouterFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void startActivityForResult(Class<?> clazz, Callback callback) {
        Intent intent = new Intent(this.mContext, clazz);
        this.startActivityForResult(intent, callback);
    }

    public void startActivityForResult(Intent intent, Callback callback) {
        if (this.mRouterFragmentV4 != null) {
            this.mRouterFragmentV4.startActivityForResult(intent, callback);
        } else if (this.mRouterFragment != null) {
            this.mRouterFragment.startActivityForResult(intent, callback);
        } else if (this.mContext != null) {
            this.mContext.startActivity(intent);
        } else {
            throw new RuntimeException("please do init first!");
        }
    }

    public static interface Callback {
        public void onActivityResult(int var1, Intent var2);
    }
}

