/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.adapter.storage.impl;

import android.content.SharedPreferences;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.adapter.storage.IStorageAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultStorageAdapter
implements IStorageAdapter {
    private static final String SP_NAME = "HummerStorage";
    private static final String KEY_VERSION = "_#_hummer_shared_preferences_version_#_";
    private static final int version = 1;
    private String namespace;
    private SharedPreferences sp;

    private SharedPreferences getSP() {
        if (this.sp == null) {
            this.sp = HummerSDK.appContext.getSharedPreferences(this.getSpName(this.namespace), 0);
            this.checkUpgrade(this.sp);
        }
        return this.sp;
    }

    private String getSpName(String namespace) {
        String spName = namespace != null && !"_HUMMER_SDK_NAMESPACE_DEFAULT_".equals(namespace) ? "HummerStorage_" + namespace : "HummerStorage_default";
        return spName;
    }

    private void checkUpgrade(SharedPreferences sp) {
        try {
            int oldVer = sp.getInt(KEY_VERSION, 0);
            if (1 > oldVer) {
                SharedPreferences.Editor editor = sp.edit();
                SharedPreferences oldSP = HummerSDK.appContext.getSharedPreferences(SP_NAME, 0);
                Set keys = oldSP.getAll().keySet();
                for (String k : keys) {
                    if (k == null || k.equals(KEY_VERSION)) continue;
                    try {
                        editor.putString(k, oldSP.getString(k, ""));
                    }
                    catch (Exception exception) {}
                }
                editor.putInt(KEY_VERSION, 1);
                editor.apply();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public void set(String key, Object value) {
        if (!(value instanceof String)) {
            return;
        }
        this.getSP().edit().putString(key, (String)value).apply();
    }

    @Override
    public Object get(String key) {
        return this.getSP().getString(key, "");
    }

    @Override
    public void remove(String key) {
        this.getSP().edit().remove(key).apply();
    }

    @Override
    public void removeAll() {
        this.getSP().edit().clear().putInt(KEY_VERSION, 1).apply();
    }

    @Override
    public Map<String, Object> getAll() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getSP().getAll());
        map.remove(KEY_VERSION);
        return map;
    }

    @Override
    public List<String> allKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.getSP().getAll().keySet());
        keys.remove(KEY_VERSION);
        return keys;
    }

    @Override
    public boolean exist(String key) {
        return this.getSP().contains(key);
    }
}

