/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.context;

import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerDefinition;
import com.didi.hummer.context.HummerInvoker;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.engine.base.ICallback;
import com.didi.hummer.core.util.BytecodeCacheUtil;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.core.util.HMGsonUtil;
import com.didi.hummer.core.util.HMLog;
import com.didi.hummer.debug.InvokerAnalyzer;
import com.didi.hummer.module.notifycenter.NotifyCenter;
import com.didi.hummer.module.notifycenter.NotifyCenterInvoker;
import com.didi.hummer.pool.ComponentPool;
import com.didi.hummer.pool.ObjectPool;
import com.didi.hummer.register.HummerRegister$$hummer_sdk;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.component.view.Invoker;
import com.didi.hummer.render.style.HummerLayout;
import com.didi.hummer.utils.EnvUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HummerContext
extends ContextWrapper {
    private static final String HUMMER_OBJECT_PREFIX = "-_-_-_hummer-object_-_-_-";
    private static final String HUMMER_ARRAY_PREFIX = "-_-_-_hummer-array_-_-_-";
    protected String namespace;
    protected HummerLayout mContainer;
    protected HummerLayout mContent;
    protected ComponentPool mComponentPool = new ComponentPool();
    protected JSContext mJsContext;
    protected HMBase mJSRootView;
    protected JSValue mJsPage;
    private OnRenderListener renderListener;
    protected InvokerAnalyzer invokerAnalyzer;
    protected String jsSourcePath = "";
    protected String pageUrl = "";
    protected boolean isJsCreated;
    protected boolean isStarted;
    protected boolean isResumed;
    protected HashMap<String, Invoker> mRegistry = new HashMap();
    protected HashMap<String, ICallback> mNativeCallbacks = new HashMap();
    private static final Map<String, String> globalBabelTransScriptMap = new HashMap<String, String>();
    protected Pattern blankCharPattern = Pattern.compile("\\s");

    protected HummerContext(@NonNull Context context) {
        super(context);
    }

    protected HummerContext(@NonNull HummerLayout container) {
        this(container, null);
    }

    protected HummerContext(@NonNull HummerLayout container, String namespace) {
        super(container.getContext());
        HMLog.d((String)"HummerNative", (String)"HummerContext.new");
        this.namespace = namespace;
        this.mContainer = container;
        this.mContent = new HummerLayout((Context)this);
        this.mContent.getYogaNode().setWidthPercent(100.0f);
        this.mContent.getYogaNode().setHeightPercent(100.0f);
        this.mContainer.addView((View)this.mContent);
        this.invokerAnalyzer = InvokerAnalyzer.init();
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void onCreate() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onCreate");
        this.registerInvoker(new HummerInvoker());
        this.registerInvoker(new NotifyCenterInvoker());
        if (HummerSDK.getJsEngine() == 4 || HummerSDK.getJsEngine() == 6) {
            if (HummerSDK.getJsEngine() == 4) {
                this.mJsContext.evaluateJavaScript("function Recycler() {}");
            }
            this.mJsContext.evaluateJavaScript("var Babel = {}");
            this.mJsContext.evaluateJavaScript(HummerDefinition.BABEL, "babel.js");
            this.mJsContext.evaluateJavaScript(HummerDefinition.ES5_CORE, "HummerDefinition_es5.js");
        } else if (HummerSDK.isSupportBytecode(this.namespace)) {
            this.mJsContext.evaluateJavaScript("const __GLOBAL__ = this;\n\nconst HUMMER_OBJECT_PREFIX = '-_-_-_hummer-object_-_-_-';\nconst HUMMER_ARRAY_PREFIX = '-_-_-_hummer-array_-_-_-';\n\nvar hm_id = 1;\nconst idGenerator = () => hm_id++;\n\nconst transSingleArg = (arg) => {\n    if (arg instanceof Base) {\n        arg = arg.objID;\n    } else if (arg instanceof Function) {\n        // do nothing\n    } else if (arg instanceof Object) {\n        arg = JSON.stringify(arg);\n    }\n    return arg;\n}\n\nconst transSingleArgWithPrefix = (arg) => {\n    if (arg instanceof Base) {\n        arg = arg.objID;\n    } else if (arg instanceof Function) {\n        // do nothing\n    } else if (arg instanceof Array) {\n        arg = HUMMER_ARRAY_PREFIX + JSON.stringify(arg);\n    } else if (arg instanceof Object) {\n        arg = HUMMER_OBJECT_PREFIX + JSON.stringify(arg);\n    }\n    return arg;\n}\n\nconst transArgs = (...args) => {\n    for (let i = 0; i < args.length; i++) {\n        args[i] = transSingleArg(args[i]);\n    }\n    return args;\n}\n\nconst transArgsWithPrefix = (...args) => {\n    for (let i = 0; i < args.length; i++) {\n        args[i] = transSingleArgWithPrefix(args[i]);\n    }\n    return args;\n}\n\nconst console = {\n    log: (...msgs) => printLog(\"console.log\", ...msgs),\n    debug: (...msgs) => printLog(\"console.debug\", ...msgs),\n    info: (...msgs) => printLog(\"console.info\", ...msgs),\n    warn: (...msgs) => printLog(\"console.warn\", ...msgs),\n    error: (...msgs) => printLog(\"console.error\", ...msgs)\n}\n\nvar __IS_DEBUG__ = false;\n/**\n * \u4e0b\u9762\u7684\u65e5\u5fd7\u6253\u5370\u903b\u8f91\uff0c\u662f\u4e3a\u4e86\u652f\u6301\u524d\u7aefconsole.log\u7684Object\u7c7b\u578b\u53c2\u6570\u548c\u591a\u53c2\u6570\u60c5\u51b5\n */\nconst printLog = (funcName, ...msgs) => {\n    if (__IS_DEBUG__) {\n        let msg = '';\n        if (msgs.length == 1) {\n            let m = msgs[0];\n            if (typeof m === 'undefined') {\n                msg = 'undefined';\n            } else if (m == null) {\n                msg = 'null';\n            } else if (m instanceof Error) {\n                msg = m.toString() + '\\n' + m.stack;\n            } else if (m instanceof Function) {\n                msg = m.toString();\n            } else if (m instanceof Object) {\n                msg = JSON.stringify(m);\n            } else {\n                msg = m.toString();\n            }\n        } else if (msgs.length > 1) {\n            for (let i = 0; i < msgs.length; i++) {\n                if (i > 0) {\n                    msg = msg.concat(', ');\n                }\n                let m = msgs[i];\n                if (typeof m === 'undefined') {\n                    msg = msg.concat('undefined');\n                } else if (m == null) {\n                    msg = msg.concat('null');\n                } else if (m instanceof Error) {\n                    msg = msg.concat(m.toString() + '\\n' + m.stack);\n                } else if (m instanceof Function) {\n                    msg = msg.concat(m.toString());\n                } else if (m instanceof Object) {\n                    msg = msg.concat(JSON.stringify(m));\n                } else {\n                    msg = msg.concat(m.toString());\n                }\n            }\n        }\n        invoke(\"Hummer\", 0, funcName, msg);\n    }\n}\n\nconst setTimeout = (func, timeout) => {\n    let timer = new Timer();\n    timer.setTimeout(func, timeout);\n    return timer;\n}\n\nconst clearTimeout = (timer) => {\n    if (timer instanceof Timer) {\n        timer.clearTimeout();\n    }\n}\n\nconst setInterval = (func, interval) => {\n    let timer = new Timer();\n    timer.setInterval(func, interval);\n    return timer;\n}\n\nconst clearInterval = (timer) => {\n    if (timer instanceof Timer) {\n        timer.clearInterval();\n    }\n}\n\nconst NotifyCenter = {\n    addEventListener: (event, callback) => {\n        invoke(\"NotifyCenter\", 0, \"addEventListener\", event, callback);\n    },\n    removeEventListener: (event, callback) => {\n        invoke(\"NotifyCenter\", 0, \"removeEventListener\", event, callback);\n    },\n    triggerEvent: (event, value) => {\n        invoke(\"NotifyCenter\", 0, \"triggerEvent\", event, JSON.stringify(value));\n    }\n}\n\nconst Hummer = {\n    setBasicWidth: (width) => {\n        invoke(\"Hummer\", 0, \"setBasicWidth\", width);\n    },\n    render: (view) => {\n        invoke(\"Hummer\", 0, \"render\", view.objID);\n    },\n    onRenderFinished: (isSucceed) => {\n        invoke(\"Hummer\", 0, \"onRenderFinished\", isSucceed);\n    },\n    getRootView: () => {\n        return invoke(\"Hummer\", 0, \"getRootView\");\n    },\n    loadScript: (script) => {\n        return invoke(\"Hummer\", 0, \"loadScript\", script);\n    },\n    loadScriptWithUrl: (url, callback) => {\n        invoke(\"Hummer\", 0, \"loadScriptWithUrl\", url, callback);\n    },\n    postException: (err) => {\n        err = transSingleArg(err);\n        invoke(\"Hummer\", 0, \"postException\", err);\n    },\n    notifyCenter: NotifyCenter,\n}\n\nclass Base {\n    constructor(className, ...args) {\n        this.className = className;\n        this.objID = idGenerator();\n        this.recycler = new Recycler(this.objID);\n\n        let params = transArgs(...args);\n        invoke(this.className, this.objID, \"constructor\", this, ...params);\n\n        // \u5df2\u5f03\u7528\n        this.initialize(...args);\n\n        // \u6b64\u65b9\u6cd5\u53ea\u7528\u4e8e\u8c03\u8bd5\uff0c\u4e3a\u4e86\u7edf\u8ba1\u7ec4\u4ef6\u6811\u548c\u51fd\u6570\u8c03\u7528\u6811\n        if (__IS_DEBUG__) {\n            invoke(this.className, this.objID, \"constructor_end\", this);\n        }\n    }\n\n    // \u5df2\u5f03\u7528\n    initialize(...args) {}\n\n    set style(arg) {\n        this._style = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"setStyle\", arg);\n    }\n\n    get style() {\n        return this._style;\n    }\n\n    set enabled(arg) {\n        this._enabled = arg;\n        invoke(this.className, this.objID, \"setEnabled\", arg);\n    }\n\n    get enabled() {\n        return this._enabled;\n    }\n\n    set accessible(arg) {\n        this._accessible = arg;\n        invoke(this.className, this.objID, \"setAccessible\", arg);\n    }\n\n    get accessible() {\n        return this._accessible;\n    }\n\n    set accessibilityLabel(arg) {\n        this._accessibilityLabel = arg;\n        invoke(this.className, this.objID, \"setAccessibilityLabel\", arg);\n    }\n\n    get accessibilityLabel() {\n        return this._accessibilityLabel;\n    }\n\n    set accessibilityHint(arg) {\n        this._accessibilityHint = arg;\n        invoke(this.className, this.objID, \"setAccessibilityHint\", arg);\n    }\n\n    get accessibilityHint() {\n        return this._accessibilityHint;\n    }\n\n    set accessibilityRole(arg) {\n        this._accessibilityRole = arg;\n        invoke(this.className, this.objID, \"setAccessibilityRole\", arg);\n    }\n\n    get accessibilityRole() {\n        return this._accessibilityRole;\n    }\n\n    set accessibilityState(arg) {\n        this._accessibilityState = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"setAccessibilityState\", arg);\n    }\n\n    get accessibilityState() {\n        return this._accessibilityState;\n    }\n\n    addEventListener(...args) {\n        invoke(this.className, this.objID, \"addEventListener\", ...args);\n    }\n\n    removeEventListener(...args) {\n        invoke(this.className, this.objID, \"removeEventListener\", ...args);\n    }\n\n    addAnimation(...args) {\n        let stash = args;\n        args = transArgs(...args);\n        invoke(this.className, this.objID, \"addAnimation\", ...args);\n    }\n\n    removeAnimationForKey(arg) {\n        invoke(this.className, this.objID, \"removeAnimationForKey\", arg);\n    }\n\n    removeAllAnimation() {\n        invoke(this.className, this.objID, \"removeAllAnimation\");\n    }\n\n    getRect(arg) {\n        invoke(this.className, this.objID, \"getRect\", arg);\n    }\n\n    resetStyle() {\n        invoke(this.className, this.objID, \"resetStyle\");\n    }\n\n    recycle() {\n        invoke(this.className, this.objID, \"recycle\");\n    }\n\n    dbg_highlight(arg) {\n        let stash = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"dbg_highlight\", arg);\n    }\n\n    dbg_getDescription(...args) {\n        let stash = args;\n        args = transArgs(...args);\n        invoke(this.className, this.objID, \"dbg_getDescription\", ...args);\n    }\n}\n\n__GLOBAL__.Hummer = Hummer;\n__GLOBAL__.Base = Base;", "HummerDefinition.js");
        } else {
            this.mJsContext.evaluateJavaScriptOnly("const __GLOBAL__ = this;\n\nconst HUMMER_OBJECT_PREFIX = '-_-_-_hummer-object_-_-_-';\nconst HUMMER_ARRAY_PREFIX = '-_-_-_hummer-array_-_-_-';\n\nvar hm_id = 1;\nconst idGenerator = () => hm_id++;\n\nconst transSingleArg = (arg) => {\n    if (arg instanceof Base) {\n        arg = arg.objID;\n    } else if (arg instanceof Function) {\n        // do nothing\n    } else if (arg instanceof Object) {\n        arg = JSON.stringify(arg);\n    }\n    return arg;\n}\n\nconst transSingleArgWithPrefix = (arg) => {\n    if (arg instanceof Base) {\n        arg = arg.objID;\n    } else if (arg instanceof Function) {\n        // do nothing\n    } else if (arg instanceof Array) {\n        arg = HUMMER_ARRAY_PREFIX + JSON.stringify(arg);\n    } else if (arg instanceof Object) {\n        arg = HUMMER_OBJECT_PREFIX + JSON.stringify(arg);\n    }\n    return arg;\n}\n\nconst transArgs = (...args) => {\n    for (let i = 0; i < args.length; i++) {\n        args[i] = transSingleArg(args[i]);\n    }\n    return args;\n}\n\nconst transArgsWithPrefix = (...args) => {\n    for (let i = 0; i < args.length; i++) {\n        args[i] = transSingleArgWithPrefix(args[i]);\n    }\n    return args;\n}\n\nconst console = {\n    log: (...msgs) => printLog(\"console.log\", ...msgs),\n    debug: (...msgs) => printLog(\"console.debug\", ...msgs),\n    info: (...msgs) => printLog(\"console.info\", ...msgs),\n    warn: (...msgs) => printLog(\"console.warn\", ...msgs),\n    error: (...msgs) => printLog(\"console.error\", ...msgs)\n}\n\nvar __IS_DEBUG__ = false;\n/**\n * \u4e0b\u9762\u7684\u65e5\u5fd7\u6253\u5370\u903b\u8f91\uff0c\u662f\u4e3a\u4e86\u652f\u6301\u524d\u7aefconsole.log\u7684Object\u7c7b\u578b\u53c2\u6570\u548c\u591a\u53c2\u6570\u60c5\u51b5\n */\nconst printLog = (funcName, ...msgs) => {\n    if (__IS_DEBUG__) {\n        let msg = '';\n        if (msgs.length == 1) {\n            let m = msgs[0];\n            if (typeof m === 'undefined') {\n                msg = 'undefined';\n            } else if (m == null) {\n                msg = 'null';\n            } else if (m instanceof Error) {\n                msg = m.toString() + '\\n' + m.stack;\n            } else if (m instanceof Function) {\n                msg = m.toString();\n            } else if (m instanceof Object) {\n                msg = JSON.stringify(m);\n            } else {\n                msg = m.toString();\n            }\n        } else if (msgs.length > 1) {\n            for (let i = 0; i < msgs.length; i++) {\n                if (i > 0) {\n                    msg = msg.concat(', ');\n                }\n                let m = msgs[i];\n                if (typeof m === 'undefined') {\n                    msg = msg.concat('undefined');\n                } else if (m == null) {\n                    msg = msg.concat('null');\n                } else if (m instanceof Error) {\n                    msg = msg.concat(m.toString() + '\\n' + m.stack);\n                } else if (m instanceof Function) {\n                    msg = msg.concat(m.toString());\n                } else if (m instanceof Object) {\n                    msg = msg.concat(JSON.stringify(m));\n                } else {\n                    msg = msg.concat(m.toString());\n                }\n            }\n        }\n        invoke(\"Hummer\", 0, funcName, msg);\n    }\n}\n\nconst setTimeout = (func, timeout) => {\n    let timer = new Timer();\n    timer.setTimeout(func, timeout);\n    return timer;\n}\n\nconst clearTimeout = (timer) => {\n    if (timer instanceof Timer) {\n        timer.clearTimeout();\n    }\n}\n\nconst setInterval = (func, interval) => {\n    let timer = new Timer();\n    timer.setInterval(func, interval);\n    return timer;\n}\n\nconst clearInterval = (timer) => {\n    if (timer instanceof Timer) {\n        timer.clearInterval();\n    }\n}\n\nconst NotifyCenter = {\n    addEventListener: (event, callback) => {\n        invoke(\"NotifyCenter\", 0, \"addEventListener\", event, callback);\n    },\n    removeEventListener: (event, callback) => {\n        invoke(\"NotifyCenter\", 0, \"removeEventListener\", event, callback);\n    },\n    triggerEvent: (event, value) => {\n        invoke(\"NotifyCenter\", 0, \"triggerEvent\", event, JSON.stringify(value));\n    }\n}\n\nconst Hummer = {\n    setBasicWidth: (width) => {\n        invoke(\"Hummer\", 0, \"setBasicWidth\", width);\n    },\n    render: (view) => {\n        invoke(\"Hummer\", 0, \"render\", view.objID);\n    },\n    onRenderFinished: (isSucceed) => {\n        invoke(\"Hummer\", 0, \"onRenderFinished\", isSucceed);\n    },\n    getRootView: () => {\n        return invoke(\"Hummer\", 0, \"getRootView\");\n    },\n    loadScript: (script) => {\n        return invoke(\"Hummer\", 0, \"loadScript\", script);\n    },\n    loadScriptWithUrl: (url, callback) => {\n        invoke(\"Hummer\", 0, \"loadScriptWithUrl\", url, callback);\n    },\n    postException: (err) => {\n        err = transSingleArg(err);\n        invoke(\"Hummer\", 0, \"postException\", err);\n    },\n    notifyCenter: NotifyCenter,\n}\n\nclass Base {\n    constructor(className, ...args) {\n        this.className = className;\n        this.objID = idGenerator();\n        this.recycler = new Recycler(this.objID);\n\n        let params = transArgs(...args);\n        invoke(this.className, this.objID, \"constructor\", this, ...params);\n\n        // \u5df2\u5f03\u7528\n        this.initialize(...args);\n\n        // \u6b64\u65b9\u6cd5\u53ea\u7528\u4e8e\u8c03\u8bd5\uff0c\u4e3a\u4e86\u7edf\u8ba1\u7ec4\u4ef6\u6811\u548c\u51fd\u6570\u8c03\u7528\u6811\n        if (__IS_DEBUG__) {\n            invoke(this.className, this.objID, \"constructor_end\", this);\n        }\n    }\n\n    // \u5df2\u5f03\u7528\n    initialize(...args) {}\n\n    set style(arg) {\n        this._style = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"setStyle\", arg);\n    }\n\n    get style() {\n        return this._style;\n    }\n\n    set enabled(arg) {\n        this._enabled = arg;\n        invoke(this.className, this.objID, \"setEnabled\", arg);\n    }\n\n    get enabled() {\n        return this._enabled;\n    }\n\n    set accessible(arg) {\n        this._accessible = arg;\n        invoke(this.className, this.objID, \"setAccessible\", arg);\n    }\n\n    get accessible() {\n        return this._accessible;\n    }\n\n    set accessibilityLabel(arg) {\n        this._accessibilityLabel = arg;\n        invoke(this.className, this.objID, \"setAccessibilityLabel\", arg);\n    }\n\n    get accessibilityLabel() {\n        return this._accessibilityLabel;\n    }\n\n    set accessibilityHint(arg) {\n        this._accessibilityHint = arg;\n        invoke(this.className, this.objID, \"setAccessibilityHint\", arg);\n    }\n\n    get accessibilityHint() {\n        return this._accessibilityHint;\n    }\n\n    set accessibilityRole(arg) {\n        this._accessibilityRole = arg;\n        invoke(this.className, this.objID, \"setAccessibilityRole\", arg);\n    }\n\n    get accessibilityRole() {\n        return this._accessibilityRole;\n    }\n\n    set accessibilityState(arg) {\n        this._accessibilityState = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"setAccessibilityState\", arg);\n    }\n\n    get accessibilityState() {\n        return this._accessibilityState;\n    }\n\n    addEventListener(...args) {\n        invoke(this.className, this.objID, \"addEventListener\", ...args);\n    }\n\n    removeEventListener(...args) {\n        invoke(this.className, this.objID, \"removeEventListener\", ...args);\n    }\n\n    addAnimation(...args) {\n        let stash = args;\n        args = transArgs(...args);\n        invoke(this.className, this.objID, \"addAnimation\", ...args);\n    }\n\n    removeAnimationForKey(arg) {\n        invoke(this.className, this.objID, \"removeAnimationForKey\", arg);\n    }\n\n    removeAllAnimation() {\n        invoke(this.className, this.objID, \"removeAllAnimation\");\n    }\n\n    getRect(arg) {\n        invoke(this.className, this.objID, \"getRect\", arg);\n    }\n\n    resetStyle() {\n        invoke(this.className, this.objID, \"resetStyle\");\n    }\n\n    recycle() {\n        invoke(this.className, this.objID, \"recycle\");\n    }\n\n    dbg_highlight(arg) {\n        let stash = arg;\n        arg = transSingleArg(arg);\n        invoke(this.className, this.objID, \"dbg_highlight\", arg);\n    }\n\n    dbg_getDescription(...args) {\n        let stash = args;\n        args = transArgs(...args);\n        invoke(this.className, this.objID, \"dbg_getDescription\", ...args);\n    }\n}\n\n__GLOBAL__.Hummer = Hummer;\n__GLOBAL__.Base = Base;", "HummerDefinition.js");
        }
        this.mJsContext.set("__IS_DEBUG__", DebugUtil.isDebuggable());
        this.initEnv(EnvUtil.getHummerEnv((Context)this, this.namespace));
        HummerRegister$$hummer_sdk.init(this);
    }

    public void onStart() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onStart");
        this.isStarted = true;
        this.startIfNeed();
    }

    public void onResume() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onResume");
        this.isResumed = true;
        this.resumeIfNeed();
    }

    public void onPause() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onPause");
        this.isResumed = false;
        this.pause();
    }

    public void onStop() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onStop");
        this.isStarted = false;
        this.stop();
    }

    public void onDestroy() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.onDestroy");
        InvokerAnalyzer.release(this.invokerAnalyzer);
        this.destroy();
        NotifyCenter.release(this.getContext());
        NotifyCenter.release(this.mJsContext);
        this.releaseJSContext();
    }

    public boolean onBack() {
        return this.back();
    }

    public void onHotReload(String url) {
        this.stop();
        this.pause();
        this.destroy();
        NotifyCenter.release(this.getContext());
        NotifyCenter.release(this.mJsContext);
        BytecodeCacheUtil.removeBytecode((String)url);
    }

    protected void releaseJSContext() {
        HMLog.d((String)"HummerNative", (String)"HummerContext.releaseJSContext");
        this.mJsContext.release();
    }

    public void render(HMBase base) {
        if (base != null) {
            this.mJSRootView = base;
            this.mJsPage = base.getJSValue();
            this.mJsPage.protect();
            this.create();
            if (this.mContent != null) {
                this.mContent.removeAllViews();
                this.mContent.addView(base);
            }
            this.startIfNeed();
            this.resumeIfNeed();
        }
    }

    public void setRenderListener(OnRenderListener listener) {
        this.renderListener = listener;
    }

    public void onRenderFinished(boolean isSucceed) {
        if (this.renderListener != null) {
            this.renderListener.onRenderFinished(isSucceed);
        }
    }

    public HummerLayout getContainer() {
        return this.mContainer;
    }

    public HMBase getJSRootView() {
        return this.mJSRootView;
    }

    public JSValue getJsPage() {
        return this.mJsPage;
    }

    public InvokerAnalyzer getInvokerAnalyzer() {
        return this.invokerAnalyzer;
    }

    public Context getContext() {
        return this.getBaseContext();
    }

    public JSContext getJsContext() {
        return this.mJsContext;
    }

    public ObjectPool getObjectPool() {
        return this.mComponentPool;
    }

    public String getJsSourcePath() {
        return this.jsSourcePath;
    }

    public void setJsSourcePath(String jsSourcePath) {
        this.jsSourcePath = jsSourcePath;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    private void create() {
        this.isJsCreated = true;
        if (this.mJsPage != null) {
            this.mJsPage.callFunction("onCreate", new Object[0]);
        }
    }

    private void startIfNeed() {
        if (this.isJsCreated && this.isStarted && this.mJsPage != null) {
            this.mComponentPool.onStart();
        }
    }

    private void resumeIfNeed() {
        if (this.isJsCreated && this.isResumed && this.mJsPage != null) {
            this.mComponentPool.onResume();
            this.mJsPage.callFunction("onAppear", new Object[0]);
        }
    }

    private void pause() {
        if (this.mJsPage != null) {
            this.mJsPage.callFunction("onDisappear", new Object[0]);
        }
        this.mComponentPool.onPause();
    }

    private void stop() {
        this.mComponentPool.onStop();
    }

    private void destroy() {
        if (this.mJsPage != null) {
            this.mJsPage.callFunction("onDestroy", new Object[0]);
        }
        this.mComponentPool.onDestroy();
    }

    private boolean back() {
        Object ret;
        if (this.mJsPage != null && (ret = this.mJsPage.callFunction("onBack", new Object[0])) instanceof Boolean) {
            return (Boolean)ret;
        }
        return false;
    }

    public Object evaluateJavaScript(String script) {
        return this.evaluateJavaScript(script, "");
    }

    public Object evaluateJavaScript(String script, String scriptId) {
        if (HummerSDK.getJsEngine() == 4 || HummerSDK.getJsEngine() == 6) {
            script = this.babelTransformCode(script, scriptId);
        }
        if (HummerSDK.isSupportBytecode(this.namespace)) {
            return this.mJsContext.evaluateJavaScript(script, scriptId);
        }
        return this.mJsContext.evaluateJavaScriptOnly(script, scriptId);
    }

    public void evaluateJavaScriptAsync(String script, String scriptId, JSContext.JSEvaluateCallback callback) {
        if (HummerSDK.getJsEngine() == 4 || HummerSDK.getJsEngine() == 6) {
            script = this.babelTransformCode(script, scriptId);
        }
        this.mJsContext.evaluateJavaScriptAsync(script, scriptId, callback);
    }

    public Object evaluateBytecode(byte[] bytecode) {
        return this.mJsContext.evaluateBytecode(bytecode);
    }

    private String babelTransformCode(String script, String scriptId) {
        if (script == null || script.contains("__esModule")) {
            return script;
        }
        if (globalBabelTransScriptMap.containsKey(scriptId)) {
            return globalBabelTransScriptMap.get(scriptId);
        }
        if ("hummer_sdk.js".equals(scriptId)) {
            return HummerDefinition.ES5_SDK;
        }
        if ("hummer_component.js".equals(scriptId)) {
            return HummerDefinition.ES5_COMP;
        }
        String orgScript = script;
        if (this.blankCharPattern.matcher(script).find()) {
            script = script.replace("\\r", "\\\\r");
            script = script.replace("\\n", "\\\\n");
            script = script.replace("\\t", "\\\\t");
        }
        script = script.replace("\\\"", "\\\\\"");
        Object ret = this.mJsContext.evaluateJavaScript(script = String.format("Babel.transformCode(`%s`);", script));
        if (!(ret instanceof String)) {
            return orgScript;
        }
        script = (String)ret;
        globalBabelTransScriptMap.put(scriptId, script);
        return script;
    }

    public void registerInvoker(Invoker invoker) {
        if (invoker == null) {
            return;
        }
        this.mRegistry.put(invoker.getName(), invoker);
    }

    public Invoker getInvoker(String invokeName) {
        return this.mRegistry.get(invokeName);
    }

    public void registerJSFunction(String funcPath, ICallback callback) {
        if (TextUtils.isEmpty((CharSequence)funcPath) || callback == null) {
            return;
        }
        this.makeSureJSFunctionValid(funcPath);
        this.mNativeCallbacks.put(funcPath, callback);
    }

    public void registerJSFunction(JSValue host, String funcName, ICallback callback) {
        if (host == null || TextUtils.isEmpty((CharSequence)funcName) || callback == null) {
            return;
        }
        String funcKey = funcName + host.getIdentify();
        this.mNativeCallbacks.put(funcKey, callback);
        JSCallback jsValue = (JSCallback)this.mJsContext.evaluateJavaScript(this.makeJSFunction(funcKey));
        host.set(funcName, jsValue);
    }

    private void makeSureJSFunctionValid(String funcPath) {
        if (TextUtils.isEmpty((CharSequence)funcPath)) {
            return;
        }
        String[] items = funcPath.split("\\.");
        StringBuilder funcKey = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (i > 0) {
                funcKey.append(".");
            }
            funcKey.append(item);
            if (i < items.length - 1) {
                this.mJsContext.evaluateJavaScript(String.format("if (typeof(%s) == 'undefined') %s = {}", funcKey, funcKey));
                continue;
            }
            if (!funcPath.equals(funcKey.toString())) continue;
            this.mJsContext.evaluateJavaScript(funcKey + " = " + this.makeJSFunction(funcKey.toString()));
        }
    }

    private String makeJSFunction(String funcKey) {
        return String.format("(...args) => { \nargs = transArgsWithPrefix(...args);\nreturn invoke('Hummer', 0, '%s', ...args); };", funcKey);
    }

    public Object onJsFunctionCall(String funcName, Object ... params) {
        if (!this.mNativeCallbacks.containsKey(funcName)) {
            HMLog.w((String)"HummerNative", (String)String.format("callFromJS: didn't register this function! [%s]", funcName));
            return null;
        }
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof String)) continue;
            String p = (String)params[i];
            if (p.startsWith(HUMMER_OBJECT_PREFIX)) {
                p = p.replace(HUMMER_OBJECT_PREFIX, "");
                params[i] = HMGsonUtil.fromJson((String)p, Map.class);
                continue;
            }
            if (!p.startsWith(HUMMER_ARRAY_PREFIX)) continue;
            p = p.replace(HUMMER_ARRAY_PREFIX, "");
            params[i] = HMGsonUtil.fromJson((String)p, List.class);
        }
        HMLog.d((String)"HummerNative", (String)String.format("onJsFunctionCall: <%s> %s", funcName, Arrays.toString(params)));
        return this.mNativeCallbacks.get(funcName).call(params);
    }

    private void initEnv(Map<String, Object> envs) {
        JSValue ev;
        this.mJsContext.evaluateJavaScript("Hummer.env = {}");
        JSValue hv = this.mJsContext.getJSValue("Hummer");
        if (hv != null && (ev = hv.getJSValue("env")) != null) {
            for (String k : envs.keySet()) {
                ev.set(k, envs.get(k));
            }
        }
    }

    public void updateEnv(String key, String value) {
        JSValue ev;
        JSValue hv = this.mJsContext.getJSValue("Hummer");
        if (hv != null && (ev = hv.getJSValue("env")) != null) {
            ev.set(key, value);
        }
    }

    public static interface OnRenderListener {
        public void onRenderFinished(boolean var1);
    }
}

