/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.context;

import android.content.Context;
import android.support.annotation.NonNull;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.context.jsc.JSCHummerContext;
import com.didi.hummer.context.napi.NAPIHummerContext;
import com.didi.hummer.render.style.HummerLayout;

public class HummerContextFactory {
    private static IHummerContextCreator contextCreator;

    public static void setHummerContextCreator(IHummerContextCreator creator) {
        contextCreator = creator;
    }

    public static HummerContext createContext(@NonNull Context context) {
        if (contextCreator != null) {
            return contextCreator.create(context);
        }
        if (HummerSDK.getJsEngine() == 5 || HummerSDK.getJsEngine() == 6) {
            return new NAPIHummerContext(context);
        }
        return new JSCHummerContext(context);
    }

    public static HummerContext createContext(@NonNull HummerLayout container) {
        return HummerContextFactory.createContext(container, null);
    }

    public static HummerContext createContext(@NonNull HummerLayout container, String namespace) {
        if (contextCreator != null) {
            return contextCreator.create(container, namespace);
        }
        if (HummerSDK.getJsEngine() == 5 || HummerSDK.getJsEngine() == 6) {
            return new NAPIHummerContext(container, namespace);
        }
        return new JSCHummerContext(container, namespace);
    }

    public static interface IHummerContextCreator {
        public HummerContext create(@NonNull Context var1);

        public HummerContext create(@NonNull HummerLayout var1, String var2);
    }
}

