/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.context;

import com.didi.hummer.HummerSDK;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.context.HummerError;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.core.engine.jsc.JSCValue;
import com.didi.hummer.core.engine.jsc.jni.HummerException;
import com.didi.hummer.core.engine.jsc.jni.TypeConvertor;
import com.didi.hummer.core.exception.JSException;
import com.didi.hummer.core.util.HMJsonUtil;
import com.didi.hummer.render.component.view.BaseInvoker;
import com.didi.hummer.render.component.view.HMBase;
import com.didi.hummer.render.utility.RemUtil;
import com.didi.hummer.tools.JSLogger;
import com.didi.hummer.utils.JsSourceUtil;
import java.util.Map;

public class HummerInvoker
extends BaseInvoker<HMBase> {
    @Override
    public String getName() {
        return "Hummer";
    }

    @Override
    protected HMBase createInstance(JSValue jsValue, Object ... params) {
        return null;
    }

    @Override
    protected Object invoke(HMBase instance, String methodName, Object ... params) {
        Object jsRet = null;
        switch (methodName) {
            case "setBasicWidth": {
                RemUtil.BASE_WIDTH = ((Number)params[0]).floatValue();
                break;
            }
            case "render": {
                long objId = ((Number)params[0]).longValue();
                HMBase v = (HMBase)this.mInstanceManager.get(objId);
                this.mHummerContext.render(v);
                break;
            }
            case "onRenderFinished": {
                boolean isSucceed = (Boolean)params[0];
                this.mHummerContext.onRenderFinished(isSucceed);
                break;
            }
            case "getRootView": {
                jsRet = this.mHummerContext.getJsPage();
                if (HummerSDK.getJsEngine() != 2 || !(jsRet instanceof JSCValue)) break;
                JSCValue jsValue = (JSCValue)jsRet;
                TypeConvertor.JSValueProtect((long)jsValue.context, (long)jsValue.value);
                break;
            }
            case "loadScript": {
                jsRet = this.mHummerContext.evaluateJavaScript(String.valueOf(params[0]), "loadScript");
                jsRet = this.makeHummerError(jsRet);
                break;
            }
            case "loadScriptWithUrl": {
                String url = JsSourceUtil.relativePath2AbsolutePath(String.valueOf(params[0]), this.mHummerContext.getPageUrl());
                JSCallback callback = params.length > 1 ? (JSCallback)params[1] : null;
                HummerAdapter.getScriptLoaderAdapter(this.mHummerContext.getNamespace()).loadScriptWithUrl(url, (script, errCode, errMsg) -> {
                    if (script == null) {
                        HummerError ret2 = new HummerError(errCode, errMsg);
                        if (callback != null) {
                            callback.call(new Object[]{ret2});
                        }
                    } else if (HummerSDK.isSupportBytecode(this.mHummerContext.getNamespace())) {
                        this.mHummerContext.evaluateJavaScriptAsync(script, url, ret -> {
                            ret = this.makeHummerError(ret);
                            if (callback != null) {
                                callback.call(new Object[]{ret});
                            }
                        });
                    } else {
                        Object ret3 = this.mHummerContext.evaluateJavaScript(script, url);
                        ret3 = this.makeHummerError(ret3);
                        if (callback != null) {
                            callback.call(new Object[]{ret3});
                        }
                    }
                });
                break;
            }
            case "postException": {
                Map errMap = HMJsonUtil.toMap((String)String.valueOf(params[0]));
                String strErr = errMap.get("name") + ": " + errMap.get("message") + "\n" + errMap.get("stack");
                HummerException.nativeException((JSContext)this.mHummerContext.mJsContext, (Exception)new JSException(strErr));
                break;
            }
            case "console.log": {
                JSLogger.log(this.mHummerContext.getNamespace(), String.valueOf(params[0]));
                break;
            }
            case "console.debug": {
                JSLogger.debug(this.mHummerContext.getNamespace(), String.valueOf(params[0]));
                break;
            }
            case "console.info": {
                JSLogger.info(this.mHummerContext.getNamespace(), String.valueOf(params[0]));
                break;
            }
            case "console.warn": {
                JSLogger.warn(this.mHummerContext.getNamespace(), String.valueOf(params[0]));
                break;
            }
            case "console.error": {
                JSLogger.error(this.mHummerContext.getNamespace(), String.valueOf(params[0]));
                break;
            }
            default: {
                jsRet = this.mHummerContext.onJsFunctionCall(methodName, params);
            }
        }
        return jsRet;
    }

    private HummerError makeHummerError(Object ret) {
        HummerError err = null;
        if (HummerSDK.getJsEngine() == 5 || HummerSDK.getJsEngine() == 6) {
            if (ret instanceof JSException) {
                err = new HummerError(-1, ((JSException)ret).getMessage());
            }
        } else if (ret instanceof JSValue && ((JSValue)ret).stringValue() == null) {
            err = new HummerError(-1, "JavaScript evaluate exception");
        }
        return err;
    }
}

