/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.context.jsc;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.Toast;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.jsc.JSCContext;
import com.didi.hummer.core.engine.jsc.jni.HummerBridge;
import com.didi.hummer.core.engine.jsc.jni.HummerException;
import com.didi.hummer.core.engine.jsc.jni.HummerRecycler;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.core.util.ExceptionUtil;
import com.didi.hummer.core.util.HMLog;
import com.didi.hummer.debug.InvokerAnalyzer;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.render.component.view.Invoker;
import com.didi.hummer.render.style.HummerLayout;

public class JSCHummerContext
extends HummerContext
implements HummerBridge.InvokeCallback,
HummerRecycler.RecycleCallback {
    private HummerBridge bridge;
    private HummerRecycler recycler;

    public JSCHummerContext(@NonNull Context context) {
        super(context);
        this.mJsContext = JSCContext.create();
        HummerException.addJSContextExceptionCallback((JSContext)this.mJsContext, e -> {
            HummerSDK.getException(this.namespace).onException(e);
            if (DebugUtil.isDebuggable()) {
                this.mJsContext.evaluateJavaScript("console.error(`" + Log.getStackTraceString((Throwable)e) + "`)");
            }
        });
    }

    public JSCHummerContext(@NonNull HummerLayout container) {
        this(container, null);
    }

    public JSCHummerContext(@NonNull HummerLayout container, String namespace) {
        super(container, namespace);
        this.mJsContext = JSCContext.create();
        this.bridge = new HummerBridge(this.mJsContext.getIdentify(), (HummerBridge.InvokeCallback)this);
        this.recycler = new HummerRecycler(this.mJsContext.getIdentify(), (HummerRecycler.RecycleCallback)this);
        HummerException.addJSContextExceptionCallback((JSContext)this.mJsContext, e -> {
            ExceptionUtil.addStackTrace((Exception)e, (StackTraceElement)new StackTraceElement("<<Bundle>>", "", this.jsSourcePath, -1));
            HummerSDK.getException(namespace).onException(e);
            if (DebugUtil.isDebuggable()) {
                this.mJsContext.evaluateJavaScript("console.error(`" + Log.getStackTraceString((Throwable)e) + "`)");
                Toast.makeText((Context)HummerSDK.appContext, (CharSequence)e.getMessage(), (int)0).show();
            }
        });
        this.onCreate();
    }

    @Override
    public void releaseJSContext() {
        HummerException.removeJSContextExceptionCallback((JSContext)this.mJsContext);
        if (this.bridge != null) {
            this.bridge.onDestroy();
        }
        if (this.recycler != null) {
            this.recycler.onDestroy();
        }
        super.releaseJSContext();
    }

    public Object onInvoke(String className, long objectID, String methodName, Object ... params) {
        InvokerAnalyzer.startTrack(this.invokerAnalyzer, className, objectID, methodName, params);
        Invoker invoker = (Invoker)this.mRegistry.get(className);
        if (invoker == null) {
            HMLog.w((String)"HummerNative", (String)String.format("Invoker error: can't find this class [%s]", className));
            return null;
        }
        Object ret = invoker.onInvoke(this, objectID, methodName, params);
        InvokerAnalyzer.stopTrack(this.invokerAnalyzer);
        return ret;
    }

    public void onRecycle(long objId) {
        HMLog.v((String)"HummerNative", (String)("** onRecycle, objId = " + objId));
        Object obj = this.getObjectPool().remove(objId);
        if (obj instanceof ILifeCycle) {
            ((ILifeCycle)obj).onDestroy();
        }
    }
}

