/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.context.napi;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.Toast;
import com.didi.hummer.HummerSDK;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.base.ICallback;
import com.didi.hummer.core.engine.base.IRecycler;
import com.didi.hummer.core.engine.napi.NAPIContext;
import com.didi.hummer.core.engine.napi.jni.JSException;
import com.didi.hummer.core.exception.ExceptionCallback;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.core.util.ExceptionUtil;
import com.didi.hummer.core.util.HMLog;
import com.didi.hummer.debug.InvokerAnalyzer;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.render.component.view.Invoker;
import com.didi.hummer.render.style.HummerLayout;
import java.util.Arrays;

public class NAPIHummerContext
extends HummerContext {
    private ICallback invoker = params -> {
        Invoker invoker;
        if (params == null || params.length < 3) {
            return null;
        }
        String className = String.valueOf(params[0]);
        long objectID = ((Number)params[1]).longValue();
        String methodName = String.valueOf(params[2]);
        Object[] realParams = Arrays.copyOfRange(params, 3, params.length);
        if (DebugUtil.isDebuggable()) {
            HMLog.d((String)"HummerNative", (String)String.format("[Java invoked][objectID=%d][className=%s][method=%s][params=%s]", objectID, className, methodName, Arrays.toString(realParams)));
        }
        if ((invoker = this.getInvoker(className)) == null) {
            HMLog.w((String)"HummerNative", (String)String.format("Invoker error: can't find this class [%s]", className));
            return null;
        }
        Object ret = null;
        try {
            InvokerAnalyzer.startTrack(this.invokerAnalyzer, className, objectID, methodName, params);
            ret = invoker.onInvoke(this, objectID, methodName, realParams);
            InvokerAnalyzer.stopTrack(this.invokerAnalyzer);
        }
        catch (Exception e) {
            String jsStack = ExceptionUtil.getJSErrorStack((JSContext)this.mJsContext);
            ExceptionUtil.addStackTrace((Exception)e, (StackTraceElement)new StackTraceElement("<<JS_Stack>>", "", "\n" + jsStack, -1));
            JSException.nativeException((JSContext)this.mJsContext, (Exception)e);
        }
        return ret;
    };
    private IRecycler recycler = objId -> {
        HMLog.v((String)"HummerNative", (String)("** onRecycle, objId = " + objId));
        Object obj = this.getObjectPool().remove(objId);
        if (obj instanceof ILifeCycle) {
            ((ILifeCycle)obj).onDestroy();
        }
    };
    private ExceptionCallback exceptionCallback = e -> {
        ExceptionUtil.addStackTrace((Exception)e, (StackTraceElement)new StackTraceElement("<<Bundle>>", "", this.jsSourcePath, -1));
        HummerSDK.getException(this.namespace).onException(e);
        if (DebugUtil.isDebuggable()) {
            this.mJsContext.evaluateJavaScript("console.error(`" + Log.getStackTraceString((Throwable)e) + "`)");
            Toast.makeText((Context)HummerSDK.appContext, (CharSequence)e.getMessage(), (int)0).show();
        }
    };

    public NAPIHummerContext(@NonNull Context context) {
        super(context);
        this.mJsContext = NAPIContext.create();
        JSException.addJSContextExceptionCallback((JSContext)this.mJsContext, e -> {
            HummerSDK.getException(this.namespace).onException(e);
            if (DebugUtil.isDebuggable()) {
                this.mJsContext.evaluateJavaScript("console.error(`" + Log.getStackTraceString((Throwable)e) + "`)");
            }
        });
    }

    public NAPIHummerContext(@NonNull HummerLayout container) {
        this(container, null);
    }

    public NAPIHummerContext(@NonNull HummerLayout container, String namespace) {
        super(container, namespace);
        this.mJsContext = NAPIContext.create();
        this.mJsContext.set("invoke", (Object)this.invoker);
        this.mJsContext.setRecycler(this.recycler);
        JSException.addJSContextExceptionCallback((JSContext)this.mJsContext, (ExceptionCallback)this.exceptionCallback);
        this.onCreate();
    }

    @Override
    public void releaseJSContext() {
        JSException.removeJSContextExceptionCallback((JSContext)this.mJsContext);
        super.releaseJSContext();
    }
}

