/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.debug;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

public class Highlight {
    private static HighlightLayer layer;

    public static void show(@NonNull View view) {
        if (layer == null) {
            layer = new HighlightLayer(view.getContext());
            ViewGroup decorView = (ViewGroup)((Activity)view.getContext()).getWindow().getDecorView();
            decorView.addView((View)layer);
        }
        layer.hide();
        layer.post(() -> layer.show(view));
    }

    public static void clear() {
        if (layer != null) {
            layer.hide();
            ViewGroup decorView = (ViewGroup)((Activity)layer.getContext()).getWindow().getDecorView();
            decorView.removeView((View)layer);
            layer = null;
        }
    }

    private static class HighlightLayer
    extends View {
        private Paint mPaint;
        private Rect mRect = new Rect();

        public HighlightLayer(@NonNull Context context) {
            super(context, null);
            this.init();
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            layer = null;
        }

        private void init() {
            this.mPaint = new Paint(1);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(8.0f);
            this.mPaint.setColor(-1593901056);
        }

        public void show(View view) {
            int[] viewLocation = new int[2];
            view.getDrawingRect(this.mRect);
            view.getLocationOnScreen(viewLocation);
            this.mRect.left = viewLocation[0];
            this.mRect.top = viewLocation[1];
            this.mRect.right += this.mRect.left;
            this.mRect.bottom += this.mRect.top;
            this.postInvalidate();
        }

        public void hide() {
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            canvas.drawRect(this.mRect, this.mPaint);
        }
    }
}

