/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.debug;

import java.text.SimpleDateFormat;
import java.util.Arrays;

public class InvokeTracker {
    public String className;
    public long objectID;
    public String methodName;
    public Object[] params;
    public String desc;
    public long beginTime;
    public long endTime;
    public long timeCost;
    public long timestamp;
    public String timeFormat;

    public InvokeTracker start(String className, long objectID, String methodName, Object[] params) {
        this.beginTime = System.nanoTime();
        this.timestamp = System.currentTimeMillis();
        this.timeFormat = new SimpleDateFormat("HH:mm:ss.SSS").format(this.timestamp);
        this.className = className;
        this.objectID = objectID;
        this.methodName = methodName;
        this.params = params;
        if (methodName.startsWith("constructor") && params.length > 0) {
            this.params = Arrays.copyOfRange(params, 1, params.length);
        }
        return this;
    }

    public InvokeTracker stop() {
        this.endTime = System.nanoTime();
        this.timeCost = this.endTime - this.beginTime;
        return this;
    }
}

