/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.debug;

import android.os.Handler;
import com.didi.hummer.core.util.DebugUtil;
import com.didi.hummer.debug.InvokeTracker;
import com.didi.hummer.debug.PerformanceTracker;
import java.util.ArrayList;
import java.util.List;

public class InvokerAnalyzer {
    private final Handler analyzeHandler = new Handler();
    private final List<InvokeTracker> invokeTrackerList = new ArrayList<InvokeTracker>();
    private final List<PerformanceTracker> perfTrackerList = new ArrayList<PerformanceTracker>();
    private InvokeTracker curTracker;
    private PerformanceTracker curPerfTracker;
    private boolean isPerformanceTracking;

    public static InvokerAnalyzer init() {
        if (!DebugUtil.isDebuggable()) {
            return null;
        }
        return new InvokerAnalyzer();
    }

    public static void release(InvokerAnalyzer analyzer) {
        if (!DebugUtil.isDebuggable() || analyzer == null) {
            return;
        }
        analyzer.release();
    }

    public static void startTrack(InvokerAnalyzer analyzer, String className, long objectID, String methodName, Object[] params) {
        if (!DebugUtil.isDebuggable() || analyzer == null) {
            return;
        }
        analyzer.startTrack(className, objectID, methodName, params);
    }

    public static void stopTrack(InvokerAnalyzer analyzer) {
        if (!DebugUtil.isDebuggable() || analyzer == null) {
            return;
        }
        analyzer.stopTrack();
    }

    private InvokerAnalyzer() {
    }

    private void release() {
        this.analyzeHandler.removeCallbacksAndMessages(null);
    }

    private void startTrack(String className, long objectID, String methodName, Object[] params) {
        this.postAnalyzePerformance();
        this.curTracker = new InvokeTracker().start(className, objectID, methodName, params);
        this.invokeTrackerList.add(this.curTracker);
    }

    private void stopTrack() {
        if (this.curTracker != null) {
            this.curTracker.stop();
            if (this.curPerfTracker != null) {
                this.curPerfTracker.track(this.curTracker);
            }
            this.curTracker = null;
        }
    }

    private void postAnalyzePerformance() {
        if (this.isPerformanceTracking) {
            return;
        }
        this.isPerformanceTracking = true;
        this.curPerfTracker = new PerformanceTracker().start();
        this.analyzeHandler.post(() -> {
            this.perfTrackerList.add(this.curPerfTracker.stop());
            this.isPerformanceTracking = false;
        });
    }

    public List<InvokeTracker> getInvokeTrackerList() {
        return this.invokeTrackerList;
    }

    public List<PerformanceTracker> getPerfTrackerList() {
        return this.perfTrackerList;
    }
}

