/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.debug;

import com.didi.hummer.debug.InvokeTracker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerformanceTracker {
    public long beginTime;
    public long endTime;
    public long totalCost;
    public long invokeCost;
    public long otherCost;
    public long timestamp;
    public String timeFormat;
    public List<String> sourceCallStack;
    public List<InvokeTracker> trackerList = new ArrayList<InvokeTracker>();
    public Map<String, TimeCost> timeCostMap = new HashMap<String, TimeCost>();
    public List<Map.Entry<String, TimeCost>> sortTimeCostList;

    public PerformanceTracker start() {
        this.beginTime = System.nanoTime();
        this.timestamp = System.currentTimeMillis();
        this.timeFormat = new SimpleDateFormat("HH:mm:ss.SSS").format(this.timestamp);
        this.sourceCallStack = this.getSourceCallStack(Thread.currentThread().getStackTrace());
        return this;
    }

    public PerformanceTracker track(InvokeTracker tracker) {
        this.trackerList.add(tracker);
        this.invokeCost += tracker.timeCost;
        String key = tracker.className + "." + tracker.methodName;
        TimeCost timeCost = this.timeCostMap.get(key);
        if (timeCost == null) {
            timeCost = new TimeCost();
            this.timeCostMap.put(key, timeCost);
        }
        long cost = tracker.timeCost;
        timeCost.increase(cost);
        return this;
    }

    public PerformanceTracker stop() {
        this.endTime = System.nanoTime();
        this.totalCost = this.endTime - this.beginTime;
        this.otherCost = this.totalCost - this.invokeCost;
        this.sortTimeCostList = new ArrayList<Map.Entry<String, TimeCost>>(this.timeCostMap.entrySet());
        Collections.sort(this.sortTimeCostList, (e1, e2) -> -Long.compare(((TimeCost)e1.getValue()).cost, ((TimeCost)e2.getValue()).cost));
        return this;
    }

    private List<String> getSourceCallStack(StackTraceElement[] curStackTrace) {
        ArrayList<String> stack = new ArrayList<String>();
        int index = 0;
        for (StackTraceElement stackTraceElement : curStackTrace) {
            String strStack = stackTraceElement.toString();
            if ((strStack.contains("evaluateJavaScript(Native Method)") || strStack.contains("evaluateBytecode(Native Method)") || strStack.contains("callFunction(Native Method)")) && index + 4 < curStackTrace.length) {
                for (int i = 0; i <= 4; ++i) {
                    stack.add(curStackTrace[index + i].toString());
                }
            }
            ++index;
        }
        return stack;
    }

    public static class TimeCost {
        public int count;
        public long cost;

        public void increase(long timeCost) {
            ++this.count;
            this.cost += timeCost;
        }
    }
}

