/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import android.text.TextUtils;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.context.HummerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component(value="Memory")
public class Memory {
    private static Map<String, Map<String, Object>> memoryStoreMap = new ConcurrentHashMap<String, Map<String, Object>>();

    @JsMethod(value="set")
    public static void set(HummerContext context, String key, Object value) {
        Memory.set(context.getNamespace(), key, value);
    }

    @JsMethod(value="get")
    public static Object get(HummerContext context, String key) {
        return Memory.get(context.getNamespace(), key);
    }

    @JsMethod(value="remove")
    public static void remove(HummerContext context, String key) {
        Memory.remove(context.getNamespace(), key);
    }

    @JsMethod(value="removeAll")
    public static void removeAll(HummerContext context) {
        Memory.removeAll(context.getNamespace());
    }

    @JsMethod(value="getAll")
    public static Map<String, Object> getAll(HummerContext context) {
        return Memory.getAll(context.getNamespace());
    }

    @JsMethod(value="allKeys")
    public static List<String> allKeys(HummerContext context) {
        return Memory.allKeys(context.getNamespace());
    }

    @JsMethod(value="exist")
    public static boolean exist(HummerContext context, String key) {
        return Memory.exist(context.getNamespace(), key);
    }

    private static String checkNamespace(String namespace) {
        if (TextUtils.isEmpty((CharSequence)namespace)) {
            return "_HUMMER_SDK_NAMESPACE_DEFAULT_";
        }
        return namespace;
    }

    public static void set(String namespace, String key, Object value) {
        Map<String, Object> memoryStore = memoryStoreMap.get(namespace = Memory.checkNamespace(namespace));
        if (memoryStore == null) {
            memoryStore = new ConcurrentHashMap<String, Object>();
            memoryStoreMap.put(namespace, memoryStore);
        }
        memoryStore.put(key, value);
    }

    public static Object get(String namespace, String key) {
        Map<String, Object> memoryStore = memoryStoreMap.get(namespace = Memory.checkNamespace(namespace));
        if (memoryStore == null) {
            return null;
        }
        return memoryStore.get(key);
    }

    public static void remove(String namespace, String key) {
        Map<String, Object> memoryStore = memoryStoreMap.get(namespace = Memory.checkNamespace(namespace));
        if (memoryStore == null) {
            return;
        }
        memoryStore.remove(key);
    }

    public static void removeAll(String namespace) {
        Map<String, Object> memoryStore = memoryStoreMap.get(namespace = Memory.checkNamespace(namespace));
        if (memoryStore == null) {
            return;
        }
        memoryStore.clear();
    }

    public static Map<String, Object> getAll(String namespace) {
        namespace = Memory.checkNamespace(namespace);
        return memoryStoreMap.get(namespace);
    }

    public static List<String> allKeys(String namespace) {
        namespace = Memory.checkNamespace(namespace);
        return new ArrayList<String>(memoryStoreMap.get(namespace).keySet());
    }

    public static boolean exist(String namespace, String key) {
        Map<String, Object> memoryStore = memoryStoreMap.get(namespace = Memory.checkNamespace(namespace));
        if (memoryStore == null) {
            return false;
        }
        return memoryStore.containsKey(key);
    }
}

