/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.navigator.NavPage;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.utils.JsSourceUtil;

@Component(value="Navigator")
public class Navigator {
    @JsMethod(value="openPage")
    public static void openPage(HummerContext context, NavPage page, JSCallback callback) {
        if (page != null) {
            page.url = JsSourceUtil.relativePath2AbsolutePath(page.url, context.getPageUrl());
            page.sourcePath = JsSourceUtil.relativePath2AbsolutePath(page.url, context.getJsSourcePath());
        }
        HummerAdapter.getNavigatorAdapter(context.getNamespace()).openPage(context.getBaseContext(), page, data -> {
            if (callback != null) {
                callback.call(new Object[]{data});
                callback.release();
            }
        });
    }

    @JsMethod(value="popPage")
    public static void popPage(HummerContext context, NavPage page) {
        HummerAdapter.getNavigatorAdapter(context.getNamespace()).popPage(context.getBaseContext(), page);
    }

    @JsMethod(value="popToPage")
    public static void popToPage(HummerContext context, NavPage page) {
        HummerAdapter.getNavigatorAdapter(context.getNamespace()).popToPage(context.getBaseContext(), page);
    }

    @JsMethod(value="popToRootPage")
    public static void popToRootPage(HummerContext context, NavPage page) {
        HummerAdapter.getNavigatorAdapter(context.getNamespace()).popToRootPage(context.getBaseContext(), page);
    }

    @JsMethod(value="popBack")
    public static void popBack(HummerContext context, int count, NavPage page) {
        HummerAdapter.getNavigatorAdapter(context.getNamespace()).popBack(context.getBaseContext(), count, page);
    }
}

