/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import android.text.TextUtils;
import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.http.IHttpAdapter;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.lifecycle.ILifeCycle;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@Component(value="Request")
public class Request
implements ILifeCycle {
    @JsProperty(value="url")
    public String url = "";
    @JsProperty(value="method")
    public String method = "POST";
    @JsProperty(value="timeout")
    public int timeout = 10000;
    @JsProperty(value="header")
    public Map<String, Object> header;
    @JsProperty(value="param")
    public Map<String, Object> param;
    private JSValue jsValue;
    private IHttpAdapter httpAdapter;
    private AtomicBoolean isDestroyed = new AtomicBoolean(false);

    public Request(HummerContext context, JSValue jsValue) {
        this.jsValue = jsValue;
        this.httpAdapter = HummerAdapter.getHttpAdapter(context.getNamespace());
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onDestroy() {
        this.isDestroyed.set(true);
        this.jsValue.unprotect();
    }

    public void setUrl(String api) {
        String interceptedUrl;
        if (this.httpAdapter != null && !TextUtils.isEmpty((CharSequence)(interceptedUrl = this.httpAdapter.onUrlIntercept(api)))) {
            this.url = interceptedUrl;
            return;
        }
        this.url = api;
    }

    public void setMethod(String method) {
        if (!TextUtils.isEmpty((CharSequence)method)) {
            this.method = method.toUpperCase();
        }
    }

    @JsMethod(value="send")
    public void send(JSCallback func) {
        this.jsValue.protect();
        this.httpAdapter.request(this.url, this.method, this.timeout, this.header, this.param, response -> {
            if (this.isDestroyed.get()) {
                return;
            }
            if (func != null) {
                func.call(new Object[]{response});
                func.release();
            }
            this.jsValue.unprotect();
        }, (Type)((Object)Object.class));
    }
}

