/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import android.os.Handler;
import android.os.Looper;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.lifecycle.ILifeCycle;
import java.util.concurrent.atomic.AtomicBoolean;

@Component(value="Timer")
public class Timer
implements ILifeCycle {
    private static Handler timerHandler = new Handler(Looper.getMainLooper());
    private JSValue jsValue;
    private Runnable intervalRunnable;
    private Runnable timeoutRunnable;
    private JSCallback intervalCallback;
    private JSCallback timeoutCallback;
    private boolean isIntervalRunning;
    private boolean isIntervalCleared;
    private boolean isTimeoutRunning;
    private AtomicBoolean isDestroyed = new AtomicBoolean(false);

    public Timer(JSValue jsValue) {
        this.jsValue = jsValue;
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onDestroy() {
        this.isDestroyed.set(true);
        this.clearInterval();
        this.clearTimeout();
    }

    @JsMethod(value="setInterval")
    public void setInterval(JSCallback callback, long interval) {
        this.jsValue.protect();
        this.intervalCallback = callback;
        if (this.intervalRunnable != null) {
            timerHandler.removeCallbacks(this.intervalRunnable);
        }
        this.intervalRunnable = () -> {
            if (this.isDestroyed.get()) {
                return;
            }
            this.isIntervalRunning = true;
            timerHandler.postDelayed(this.intervalRunnable, interval);
            if (callback != null) {
                callback.call(new Object[0]);
                if (this.isIntervalCleared) {
                    callback.release();
                    this.isIntervalCleared = false;
                }
            }
            this.isIntervalRunning = false;
        };
        timerHandler.postDelayed(this.intervalRunnable, interval);
    }

    @JsMethod(value="clearInterval")
    public void clearInterval() {
        if (this.intervalRunnable != null) {
            timerHandler.removeCallbacks(this.intervalRunnable);
        }
        if (!this.isIntervalRunning) {
            if (this.intervalCallback != null) {
                this.intervalCallback.release();
                this.intervalCallback = null;
            }
        } else {
            this.isIntervalCleared = true;
        }
        this.jsValue.unprotect();
    }

    @JsMethod(value="setTimeout")
    public void setTimeout(JSCallback callback, long timeout) {
        this.jsValue.protect();
        this.timeoutCallback = callback;
        if (this.timeoutRunnable != null) {
            timerHandler.removeCallbacks(this.timeoutRunnable);
        }
        this.timeoutRunnable = () -> {
            if (this.isDestroyed.get()) {
                return;
            }
            this.isTimeoutRunning = true;
            if (callback != null) {
                callback.call(new Object[0]);
                callback.release();
            }
            this.jsValue.unprotect();
            this.isTimeoutRunning = false;
        };
        timerHandler.postDelayed(this.timeoutRunnable, timeout);
    }

    @JsMethod(value="clearTimeout")
    public void clearTimeout() {
        if (this.timeoutRunnable != null) {
            timerHandler.removeCallbacks(this.timeoutRunnable);
        }
        if (!this.isTimeoutRunning && this.timeoutCallback != null) {
            this.timeoutCallback.release();
            this.timeoutCallback = null;
        }
        this.jsValue.unprotect();
    }
}

