/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import com.didi.hummer.adapter.HummerAdapter;
import com.didi.hummer.adapter.tracker.PerfCustomInfo;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.exception.JSException;
import java.io.Serializable;

@Component(value="Tracker")
public class Tracker {
    @JsMethod(value="trackPerformance")
    public static void trackPerformance(HummerContext context, JSPerfCustomInfo info) {
        if (info == null) {
            return;
        }
        PerfCustomInfo perfInfo = new PerfCustomInfo(info.label, info.localizableLabel, info.unit, info.value);
        HummerAdapter.getTrackerAdapter(context.getNamespace()).trackPerfCustomInfo(context.getPageUrl(), perfInfo);
    }

    @JsMethod(value="trackException")
    public static void trackException(HummerContext context, JSErrorInfo info) {
        if (info == null) {
            return;
        }
        String strErr = info.name + ": " + info.message + "\n" + info.stack;
        HummerAdapter.getTrackerAdapter(context.getNamespace()).trackException(context.getPageUrl(), (Exception)new JSException(strErr));
    }

    public static class JSErrorInfo
    implements Serializable {
        public String name;
        public String message;
        public String stack;
        public String line;
        public String column;
    }

    public static class JSPerfCustomInfo
    implements Serializable {
        public String label;
        public String localizableLabel;
        public String value;
        public String unit;
    }
}

