/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module;

import android.text.TextUtils;
import com.didi.hummer.annotation.Component;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.annotation.JsProperty;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSValue;
import com.didi.hummer.lifecycle.ILifeCycle;
import com.didi.hummer.utils.UIThreadUtil;
import java.io.EOFException;
import java.util.HashMap;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;

@Component(value="WebSocket")
public class WebSocket
implements ILifeCycle {
    private static OkHttpClient client;
    private okhttp3.WebSocket webSocket;
    private JSValue jsValue;
    @JsProperty(value="url")
    public String url;
    @JsProperty(value="onopen")
    private JSCallback onopen;
    @JsProperty(value="onmessage")
    private JSCallback onmessage;
    @JsProperty(value="onclose")
    private JSCallback onclose;
    @JsProperty(value="onerror")
    private JSCallback onerror;

    public WebSocket(JSValue jsValue, String url) {
        if (client == null) {
            client = new OkHttpClient();
        }
        this.jsValue = jsValue;
        if (jsValue != null) {
            jsValue.protect();
        }
        this.connect(url);
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onDestroy() {
        if (this.webSocket != null) {
            this.webSocket.close(CloseCodes.CLOSE_GOING_AWAY.getCode(), CloseCodes.CLOSE_GOING_AWAY.name());
        }
        if (this.onopen != null) {
            this.onopen.release();
            this.onopen = null;
        }
        if (this.onmessage != null) {
            this.onmessage.release();
            this.onmessage = null;
        }
        if (this.onclose != null) {
            this.onclose.release();
            this.onclose = null;
        }
        if (this.onerror != null) {
            this.onerror.release();
            this.onerror = null;
        }
    }

    private void connect(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.url = url;
        Request request = new Request.Builder().url(url).build();
        client.newWebSocket(request, new WebSocketListener(){

            public void onOpen(okhttp3.WebSocket webSocket, Response response) {
                WebSocket.this.webSocket = webSocket;
                UIThreadUtil.runOnUiThread(() -> {
                    if (WebSocket.this.onopen != null) {
                        WebSocket.this.onopen.call(new Object[0]);
                    }
                });
            }

            public void onClosed(okhttp3.WebSocket webSocket, int code, String reason) {
                UIThreadUtil.runOnUiThread(() -> {
                    if (WebSocket.this.onclose != null) {
                        HashMap<String, Object> closeEvent = new HashMap<String, Object>();
                        closeEvent.put("code", code);
                        closeEvent.put("reason", reason);
                        WebSocket.this.onclose.call(new Object[]{closeEvent});
                    }
                });
            }

            public void onFailure(okhttp3.WebSocket webSocket, Throwable t, Response response) {
                t.printStackTrace();
                UIThreadUtil.runOnUiThread(() -> {
                    if (t instanceof EOFException) {
                        if (WebSocket.this.onclose != null) {
                            WebSocket.this.onclose.call(new Object[]{CloseCodes.CLOSE_NORMAL.getCode(), CloseCodes.CLOSE_NORMAL.name()});
                        }
                    } else if (WebSocket.this.onerror != null) {
                        WebSocket.this.onerror.call(new Object[0]);
                    }
                });
            }

            public void onMessage(okhttp3.WebSocket webSocket, String text) {
                UIThreadUtil.runOnUiThread(() -> {
                    if (WebSocket.this.onmessage != null) {
                        HashMap<String, String> messageEvent = new HashMap<String, String>();
                        messageEvent.put("data", text);
                        WebSocket.this.onmessage.call(new Object[]{messageEvent});
                    }
                });
            }
        });
    }

    @JsMethod(value="close")
    public void close() {
        if (this.webSocket != null) {
            this.webSocket.close(CloseCodes.CLOSE_NORMAL.getCode(), CloseCodes.CLOSE_NORMAL.name());
        }
        if (this.jsValue != null) {
            this.jsValue.unprotect();
        }
    }

    @JsMethod(value="send")
    public void send(String text) {
        if (this.webSocket != null) {
            this.webSocket.send(text);
        }
    }

    @JsMethod(value="addEventListener")
    public void addEventListener(String eventName, JSCallback callback) {
        switch (eventName) {
            case "open": {
                this.onopen = callback;
                break;
            }
            case "message": {
                this.onmessage = callback;
                break;
            }
            case "close": {
                this.onclose = callback;
                break;
            }
            case "error": {
                this.onerror = callback;
                break;
            }
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setOnopen(JSCallback callback) {
        this.onopen = callback;
    }

    public void setOnmessage(JSCallback callback) {
        this.onmessage = callback;
    }

    public void setOnclose(JSCallback callback) {
        this.onclose = callback;
    }

    public void setOnerror(JSCallback callback) {
        this.onerror = callback;
    }

    public static enum CloseCodes {
        CLOSE_NORMAL(1000),
        CLOSE_GOING_AWAY(1001),
        CLOSE_PROTOCOL_ERROR(1002),
        CLOSE_UNSUPPORTED(1003),
        CLOSE_NO_STATUS(1005),
        CLOSE_ABNORMAL(1006),
        UNSUPPORTED_DATA(1007),
        POLICY_VIOLATION(1008),
        CLOSE_TOO_LARGE(1009),
        MISSING_EXTENSION(1010),
        INTERNAL_ERROR(1011),
        SERVICE_RESTART(1012),
        TRY_AGAIN_LATER(1013),
        TLS_HANDSHAKE(1015);

        private int code;

        private CloseCodes(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

