/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.module.notifycenter;

import android.content.Context;
import android.support.v4.util.LongSparseArray;
import com.didi.hummer.annotation.JsMethod;
import com.didi.hummer.context.HummerContext;
import com.didi.hummer.core.engine.JSCallback;
import com.didi.hummer.core.engine.JSContext;
import com.didi.hummer.core.engine.base.ICallback;
import com.didi.hummer.module.notifycenter.NotifyCallback;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class NotifyCenter {
    private static LongSparseArray<Map<String, List<ICallback>>> globalNotifyMap = new LongSparseArray();

    private static long getContextId(ICallback callback) {
        JSContext jsContext;
        long contextId = -1L;
        if (callback == null) {
            return contextId;
        }
        if (callback instanceof NotifyCallback) {
            contextId = ((NotifyCallback)callback).getContextId();
        } else if (callback instanceof JSCallback && (jsContext = ((JSCallback)callback).getJSContext()) != null) {
            contextId = jsContext.getIdentify();
        }
        return contextId;
    }

    @JsMethod(value="triggerEvent")
    public static synchronized void triggerEvent(String key, Object value) {
        for (int i = 0; i < globalNotifyMap.size(); ++i) {
            List cbList;
            Map notifyMap = (Map)globalNotifyMap.valueAt(i);
            if (notifyMap == null || (cbList = (List)notifyMap.get(key)) == null) continue;
            for (ICallback cb : cbList) {
                cb.call(new Object[]{value});
            }
        }
    }

    @JsMethod(value="addEventListener")
    public static synchronized void addEventListener(String key, JSCallback callback) {
        NotifyCenter.addEventListener(key, (ICallback)callback);
    }

    public static synchronized void addEventListener(String key, NotifyCallback callback) {
        NotifyCenter.addEventListener(key, (ICallback)callback);
    }

    private static synchronized void addEventListener(String key, ICallback callback) {
        CopyOnWriteArrayList<ICallback> cbList;
        if (callback == null) {
            return;
        }
        long contextId = NotifyCenter.getContextId(callback);
        if (contextId < 0L) {
            return;
        }
        ConcurrentHashMap notifyMap = (ConcurrentHashMap)globalNotifyMap.get(contextId);
        if (notifyMap == null) {
            notifyMap = new ConcurrentHashMap();
            globalNotifyMap.put(contextId, notifyMap);
        }
        if ((cbList = (CopyOnWriteArrayList<ICallback>)notifyMap.get(key)) == null) {
            cbList = new CopyOnWriteArrayList<ICallback>();
            notifyMap.put(key, cbList);
        }
        if (!cbList.contains(callback)) {
            cbList.add(callback);
        }
    }

    @JsMethod(value="removeEventListener")
    public static synchronized void removeEventListener(HummerContext hmContext, String key, JSCallback callback) {
        long contextId = NotifyCenter.getContextId((ICallback)callback);
        if (contextId < 0L && hmContext != null) {
            contextId = hmContext.getJsContext().getIdentify();
        }
        NotifyCenter.removeEventListener(contextId, key, (ICallback)callback);
    }

    public static synchronized void removeEventListener(Context context, String key) {
        NotifyCenter.removeEventListener(context, key, null);
    }

    public static synchronized void removeEventListener(String key, ICallback callback) {
        NotifyCenter.removeEventListener(null, key, callback);
    }

    public static synchronized void removeEventListener(Context context, String key, ICallback callback) {
        long contextId = NotifyCenter.getContextId(callback);
        if (contextId < 0L && context != null) {
            contextId = context.hashCode();
        }
        NotifyCenter.removeEventListener(contextId, key, callback);
    }

    private static synchronized void removeEventListener(long contextId, String key, ICallback callback) {
        List cbList;
        if (contextId < 0L) {
            return;
        }
        Map notifyMap = (Map)globalNotifyMap.get(contextId);
        if (notifyMap != null && (cbList = (List)notifyMap.get(key)) != null && !cbList.isEmpty()) {
            if (callback == null) {
                for (ICallback cb : cbList) {
                    if (!(cb instanceof JSCallback)) continue;
                    ((JSCallback)cb).release();
                }
                cbList.clear();
            } else {
                ICallback cbToRemove = null;
                for (ICallback cb : cbList) {
                    if (cb == null || !cb.equals(callback)) continue;
                    cbToRemove = cb;
                    break;
                }
                if (cbToRemove instanceof JSCallback) {
                    ((JSCallback)cbToRemove).release();
                    cbList.remove(cbToRemove);
                }
            }
        }
    }

    public static synchronized void release(JSContext jsContext) {
        NotifyCenter.release(jsContext.getIdentify());
    }

    public static synchronized void release(Context context) {
        NotifyCenter.release(context.hashCode());
    }

    private static synchronized void release(long contextId) {
        Map notifyMap = (Map)globalNotifyMap.get(contextId);
        if (notifyMap != null) {
            for (String key : notifyMap.keySet()) {
                List cbList = (List)notifyMap.get(key);
                if (cbList == null || cbList.isEmpty()) continue;
                for (ICallback cb : cbList) {
                    if (!(cb instanceof JSCallback)) continue;
                    ((JSCallback)cb).release();
                }
                cbList.clear();
            }
            notifyMap.clear();
        }
        globalNotifyMap.remove(contextId);
    }

    public static synchronized void releaseAll() {
        for (int i = 0; i < globalNotifyMap.size(); ++i) {
            Map notifyMap = (Map)globalNotifyMap.valueAt(i);
            if (notifyMap == null) continue;
            for (String key : notifyMap.keySet()) {
                List cbList = (List)notifyMap.get(key);
                if (cbList == null || cbList.isEmpty()) continue;
                for (ICallback cb : cbList) {
                    if (!(cb instanceof JSCallback)) continue;
                    ((JSCallback)cb).release();
                }
                cbList.clear();
            }
            notifyMap.clear();
        }
        globalNotifyMap.clear();
    }
}

