/*
 * Decompiled with CFR 0.152.
 */
package com.didi.hummer.render.component.anim;

import android.graphics.Matrix;
import android.os.Build;
import com.didi.hummer.render.component.view.HMBase;

public class AnimViewWrapper {
    private HMBase mTarget;

    public AnimViewWrapper(HMBase base) {
        this.mTarget = base;
    }

    public void setBackgroundColor(int color) {
        this.mTarget.getBackgroundHelper().setBackgroundColor(color);
    }

    public int getBackgroundColor() {
        return this.mTarget.getBackgroundHelper().getBackgroundColor();
    }

    public void setRotation(float rotation) {
        this.mTarget.getView().setRotation(rotation);
    }

    public float getRotation() {
        return this.mTarget.getView().getRotation();
    }

    public void setRotationY(float rotationY) {
        this.mTarget.getView().setRotationY(rotationY);
    }

    public float getRotationY() {
        return this.mTarget.getView().getRotationY();
    }

    public void setRotationX(float rotationX) {
        this.mTarget.getView().setRotationX(rotationX);
    }

    public float getRotationX() {
        return this.mTarget.getView().getRotationX();
    }

    public float getScaleY() {
        return this.mTarget.getView().getScaleY();
    }

    public void setScaleY(float scaleY) {
        this.mTarget.getView().setScaleY(scaleY);
    }

    public float getScaleX() {
        return this.mTarget.getView().getScaleX();
    }

    public void setScaleX(float scaleX) {
        this.mTarget.getView().setScaleX(scaleX);
    }

    public void setTranslationX(float translationX) {
        this.mTarget.getView().setTranslationX(translationX);
    }

    public float getTranslationX() {
        return this.mTarget.getView().getTranslationX();
    }

    public void setTranslationY(float translationY) {
        this.mTarget.getView().setTranslationY(translationY);
    }

    public float getTranslationY() {
        return this.mTarget.getView().getTranslationY();
    }

    public void setAlpha(float alpha) {
        this.mTarget.getView().setAlpha(alpha);
    }

    public float getAlpha() {
        return this.mTarget.getView().getAlpha();
    }

    public void setWidth(int width) {
        this.mTarget.getYogaNode().setWidth((float)width);
        this.mTarget.getView().requestLayout();
    }

    public int getWidth() {
        return this.mTarget.getView().getWidth();
    }

    public void setHeight(int height) {
        this.mTarget.getYogaNode().setHeight((float)height);
        this.mTarget.getView().requestLayout();
    }

    public int getHeight() {
        return this.mTarget.getView().getHeight();
    }

    public void setSkewX(float x) {
        if (Build.VERSION.SDK_INT >= 29) {
            Object view = this.mTarget.getView();
            Matrix matrix = view.getAnimationMatrix();
            if (matrix == null) {
                matrix = new Matrix();
            }
            float[] values = new float[9];
            matrix.getValues(values);
            matrix.setSkew(x, values[3]);
            view.setAnimationMatrix(matrix);
        }
    }

    public float getSkewX() {
        if (Build.VERSION.SDK_INT >= 29) {
            Matrix matrix = this.mTarget.getView().getAnimationMatrix();
            if (matrix == null) {
                matrix = this.mTarget.getView().getMatrix();
            }
            float[] values = new float[9];
            matrix.getValues(values);
            return values[1];
        }
        return 0.0f;
    }

    public void setSkewY(float y) {
        if (Build.VERSION.SDK_INT >= 29) {
            Object view = this.mTarget.getView();
            Matrix matrix = view.getAnimationMatrix();
            if (matrix == null) {
                matrix = new Matrix();
            }
            float[] values = new float[9];
            matrix.getValues(values);
            matrix.setSkew(values[1], y);
            view.setAnimationMatrix(matrix);
        }
    }

    public float getSkewY() {
        if (Build.VERSION.SDK_INT >= 29) {
            Matrix matrix = this.mTarget.getView().getAnimationMatrix();
            if (matrix == null) {
                matrix = this.mTarget.getView().getMatrix();
            }
            float[] values = new float[9];
            matrix.getValues(values);
            return values[3];
        }
        return 0.0f;
    }
}

